/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class SetGroupsCommand
extends Shell.Command {
    @Override
    public String description() {
        return "sets the locality groups for a given table (for binary or commas, use Java API)";
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        HashMap groups = new HashMap();
        for (String arg : cl.getArgs()) {
            String[] sa = arg.split("=", 2);
            if (sa.length < 2) {
                throw new IllegalArgumentException("Missing '='");
            }
            String group = sa[0];
            HashSet<Text> colFams = new HashSet<Text>();
            for (String family : sa[1].split(",")) {
                colFams.add(new Text(family.getBytes(Shell.CHARSET)));
            }
            groups.put(group, colFams);
        }
        shellState.getAccumuloClient().tableOperations().setLocalityGroups(tableName, groups);
        return 0;
    }

    @Override
    public int numArgs() {
        return -1;
    }

    @Override
    public String usage() {
        return this.getName() + " <group>=<col fam>{,<col fam>}{ <group>=<col fam>{,<col fam>}}";
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        opts.addOption(OptUtil.tableOpt("table to fetch locality groups for"));
        return opts;
    }
}

