/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.tserver.compaction.WriteParameters;

@Deprecated(since="2.1.0", forRemoval=true)
public class CompactionPlan {
    public final List<StoredTabletFile> inputFiles = new ArrayList<StoredTabletFile>();
    public final List<StoredTabletFile> deleteFiles = new ArrayList<StoredTabletFile>();
    public WriteParameters writeParameters = null;

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.inputFiles);
        if (!this.deleteFiles.isEmpty()) {
            b.append(" files to be deleted ");
            b.append(this.deleteFiles);
            if (this.writeParameters != null) {
                if (this.writeParameters.getCompressType() != null) {
                    b.append(" compress type " + this.writeParameters.getCompressType());
                }
                if (this.writeParameters.getHdfsBlockSize() != 0L) {
                    b.append(" hdfs block size " + this.writeParameters.getHdfsBlockSize());
                }
                if (this.writeParameters.getBlockSize() != 0L) {
                    b.append(" data block size " + this.writeParameters.getBlockSize());
                }
                if (this.writeParameters.getIndexBlockSize() != 0L) {
                    b.append(" index block size " + this.writeParameters.getIndexBlockSize());
                }
                if (this.writeParameters.getReplication() != 0) {
                    b.append(" replication " + this.writeParameters.getReplication());
                }
            }
        }
        return b.toString();
    }

    public final void validate(Set<StoredTabletFile> allFiles) {
        HashSet<StoredTabletFile> inputSet = new HashSet<StoredTabletFile>(this.inputFiles);
        HashSet<StoredTabletFile> deleteSet = new HashSet<StoredTabletFile>(this.deleteFiles);
        if (!allFiles.containsAll(inputSet)) {
            inputSet.removeAll(allFiles);
            throw new IllegalStateException("plan inputs contains files not in allFiles " + String.valueOf(inputSet));
        }
        if (!allFiles.containsAll(deleteSet)) {
            deleteSet.removeAll(allFiles);
            throw new IllegalStateException("plan deletes contains files not in allFiles " + String.valueOf(deleteSet));
        }
        if (!Collections.disjoint(inputSet, deleteSet)) {
            throw new IllegalStateException("plan contains overlap in inputFiles and deleteFiles " + String.valueOf(Sets.intersection(inputSet, deleteSet)));
        }
    }
}

