/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcUtils.class);

    private JdbcUtils() {
    }

    public static void closeConnection(Connection connection) {
        block5: {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Could not close JDBC Connection", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!LOGGER.isDebugEnabled()) break block5;
                    LOGGER.debug("Unexpected exception on closing JDBC Connection", ex);
                }
            }
        }
    }

    public static void closeStatement(Statement statement) {
        block5: {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Could not close JDBC Statement", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!LOGGER.isDebugEnabled()) break block5;
                    LOGGER.debug("Unexpected exception on closing JDBC Statement", ex);
                }
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        block5: {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Could not close JDBC ResultSet", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!LOGGER.isDebugEnabled()) break block5;
                    LOGGER.debug("Unexpected exception on closing JDBC ResultSet", ex);
                }
            }
        }
    }
}

