# Kamelets CRDs

CRDs are [Kubernetes Custom Resources](https://kubernetes.io/docs/concepts/extend-kubernetes/api-extension/custom-resources/) used to extend the Kubernetes API. Kamelets are represented as a CRD and the version is stable in `v1` release.

This specification is a contract and any change **must** be compatible with any existing user. In case of any doubts before doing any change, please discuss with the community.

NOTE: Golang is required to do the needed changes

# Changing the specification

The specification is in a stable (`v1`) version. Make sure to understand the [Kubernetes API policy](https://kubernetes.io/docs/reference/using-api/) before performing any change. Each change to the specification is a potential break to any API client.

## Adding a new parameter

This operation is generally a safe operation and could be performed during the lifecycle of any version. It's important to notice that the addition of a new parameter should not be a mandatory parameter (to avoid breaking existing clients) and, in general, should not alter the behavior of any existing parameter.

## Deprecating an existing parameter

If any parameter is turning no longer needed, you can mark as deprecated. However, the functionality should be maintained in order to maintain compatibility with existing clients and the parameter kept in the specification as well.

## Changing a parameter behavior

This should not be performed within the lifecycle of a given version. If required, then, a new version should be issued with the new parameter.

## Deleting a parameter

This should not be performed within the lifecycle of a given version. If required, then, a new version should be issued with the new parameter. Mind that it would be advisable to issue a deprecation notice in the older version in order to let the clients know that the given parameter won't be supported in future upgraded versions.

## How to apply any change

The CRD is generated with Kubernetes [Controller Gen](https://book.kubebuilder.io/reference/controller-gen) client. You need to perform any required change to the spec by changing the Golang API struct type under `pkg/apis/camel`. Then, you just need to perform:

```bash
make generate
```

The script will regenerate the autogenerated code and will run some test to validate against the existing Kamelets. Once it's over you will need to commit the changes and provide a PR.