/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Objects;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.ExpirationDateOverflowHandling;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ObjectSizes;

public class LivenessInfo
implements IMeasurableMemory {
    public static final long NO_TIMESTAMP = Long.MIN_VALUE;
    public static final int NO_TTL = 0;
    public static final int EXPIRED_LIVENESS_TTL = Integer.MAX_VALUE;
    public static final long NO_EXPIRATION_TIME = Long.MAX_VALUE;
    public static final LivenessInfo EMPTY = new LivenessInfo(Long.MIN_VALUE);
    private static final long UNSHARED_HEAP_SIZE = ObjectSizes.measure(EMPTY);
    protected final long timestamp;

    protected LivenessInfo(long timestamp) {
        this.timestamp = timestamp;
    }

    public static LivenessInfo create(long timestamp, long nowInSec) {
        return new LivenessInfo(timestamp);
    }

    public static LivenessInfo expiring(long timestamp, int ttl, long nowInSec) {
        assert (ttl != Integer.MAX_VALUE);
        return new ExpiringLivenessInfo(timestamp, ttl, ExpirationDateOverflowHandling.computeLocalExpirationTime(nowInSec, ttl));
    }

    private static LivenessInfo expiring(long timestamp, int ttl, long nowInSec, boolean applyOverflowPolicy) {
        assert (ttl != Integer.MAX_VALUE);
        return new ExpiringLivenessInfo(timestamp, ttl, applyOverflowPolicy ? ExpirationDateOverflowHandling.computeLocalExpirationTime(nowInSec, ttl) : nowInSec);
    }

    private static LivenessInfo create(long timestamp, int ttl, long nowInSec, boolean applyOverflowPolicy) {
        return ttl == 0 ? LivenessInfo.create(timestamp, nowInSec) : LivenessInfo.expiring(timestamp, ttl, nowInSec, applyOverflowPolicy);
    }

    public static LivenessInfo create(long timestamp, int ttl, long nowInSec) {
        return ttl == 0 ? LivenessInfo.create(timestamp, nowInSec) : LivenessInfo.expiring(timestamp, ttl, nowInSec);
    }

    public static LivenessInfo withExpirationTime(long timestamp, int ttl, long localExpirationTime) {
        if (ttl == Integer.MAX_VALUE) {
            return new ExpiredLivenessInfo(timestamp, ttl, localExpirationTime);
        }
        return ttl == 0 ? new LivenessInfo(timestamp) : new ExpiringLivenessInfo(timestamp, ttl, localExpirationTime);
    }

    public boolean isEmpty() {
        return this.timestamp == Long.MIN_VALUE;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public boolean isExpiring() {
        return false;
    }

    public int ttl() {
        return 0;
    }

    public long localExpirationTime() {
        return Long.MAX_VALUE;
    }

    public boolean isLive(long nowInSec) {
        return !this.isEmpty();
    }

    public void digest(Digest digest) {
        digest.updateWithLong(this.timestamp());
    }

    public void validate() {
    }

    public int dataSize() {
        return TypeSizes.sizeof(this.timestamp());
    }

    public boolean supersedes(LivenessInfo other) {
        if (this.timestamp != other.timestamp) {
            return this.timestamp > other.timestamp;
        }
        if (this.isExpired() ^ other.isExpired()) {
            return this.isExpired();
        }
        if (this.isExpiring() == other.isExpiring()) {
            return this.localExpirationTime() > other.localExpirationTime() || this.localExpirationTime() == other.localExpirationTime() && this.ttl() < other.ttl();
        }
        return this.isExpiring();
    }

    protected boolean isExpired() {
        return false;
    }

    public LivenessInfo withUpdatedTimestamp(long newTimestamp) {
        return new LivenessInfo(newTimestamp);
    }

    public LivenessInfo withUpdatedTimestampAndLocalDeletionTime(long newTimestamp, long newLocalDeletionTime) {
        return LivenessInfo.create(newTimestamp, this.ttl(), newLocalDeletionTime, true);
    }

    public LivenessInfo withUpdatedTimestampAndLocalDeletionTime(long newTimestamp, long newLocalDeletionTime, boolean applyOverflowPolicy) {
        return LivenessInfo.create(newTimestamp, this.ttl(), newLocalDeletionTime, applyOverflowPolicy);
    }

    public String toString() {
        return String.format("[ts=%d]", this.timestamp);
    }

    public boolean equals(Object other) {
        if (!(other instanceof LivenessInfo)) {
            return false;
        }
        LivenessInfo that = (LivenessInfo)other;
        return this.timestamp() == that.timestamp() && this.ttl() == that.ttl() && this.localExpirationTime() == that.localExpirationTime();
    }

    public int hashCode() {
        return Objects.hash(this.timestamp(), this.ttl(), this.localExpirationTime());
    }

    @Override
    public long unsharedHeapSize() {
        return this == EMPTY ? 0L : UNSHARED_HEAP_SIZE;
    }

    private static class ExpiringLivenessInfo
    extends LivenessInfo {
        private final int ttl;
        private final long localExpirationTime;
        private static final long UNSHARED_HEAP_SIZE = ObjectSizes.measure(new ExpiringLivenessInfo(-1L, -1, -1L));

        private ExpiringLivenessInfo(long timestamp, int ttl, long localExpirationTime) {
            super(timestamp);
            assert (ttl != 0 && localExpirationTime != Long.MAX_VALUE);
            this.ttl = ttl;
            this.localExpirationTime = localExpirationTime;
        }

        @Override
        public int ttl() {
            return this.ttl;
        }

        @Override
        public long localExpirationTime() {
            return this.localExpirationTime;
        }

        @Override
        public boolean isExpiring() {
            return true;
        }

        @Override
        public boolean isLive(long nowInSec) {
            return nowInSec < this.localExpirationTime;
        }

        @Override
        public void digest(Digest digest) {
            super.digest(digest);
            digest.updateWithInt(Cell.deletionTimeLongToUnsignedInteger(this.localExpirationTime));
            digest.updateWithInt(this.ttl);
        }

        @Override
        public void validate() {
            if (this.ttl < 0) {
                throw new MarshalException("A TTL should not be negative");
            }
            if (this.localExpirationTime < 0L) {
                throw new MarshalException("A local expiration time should not be negative");
            }
        }

        @Override
        public int dataSize() {
            return super.dataSize() + TypeSizes.sizeof(this.ttl) + TypeSizes.sizeof(this.localExpirationTime);
        }

        @Override
        public LivenessInfo withUpdatedTimestamp(long newTimestamp) {
            return new ExpiringLivenessInfo(newTimestamp, this.ttl, this.localExpirationTime);
        }

        @Override
        public String toString() {
            return String.format("[ts=%d ttl=%d, let=%d]", this.timestamp, this.ttl, this.localExpirationTime);
        }

        @Override
        public long unsharedHeapSize() {
            return UNSHARED_HEAP_SIZE;
        }
    }

    private static class ExpiredLivenessInfo
    extends ExpiringLivenessInfo {
        private ExpiredLivenessInfo(long timestamp, int ttl, long localExpirationTime) {
            super(timestamp, ttl, localExpirationTime);
            assert (ttl == Integer.MAX_VALUE);
            assert (timestamp != Long.MIN_VALUE);
        }

        @Override
        public boolean isExpired() {
            return true;
        }

        @Override
        public boolean isLive(long nowInSec) {
            return false;
        }

        @Override
        public LivenessInfo withUpdatedTimestamp(long newTimestamp) {
            return new ExpiredLivenessInfo(newTimestamp, this.ttl(), this.localExpirationTime());
        }
    }
}

