/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.values.BooleanValue;
import org.jetbrains.annotations.NotNull;

public class BinaryBooleanReference
extends AbstractReference
implements BooleanValue {
    private static final byte FALSE = -80;
    private static final byte TRUE = -79;

    @Override
    public void bytesStore(@NotNull BytesStore bytes, @NonNegative long offset, @NonNegative long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
        this.throwExceptionIfClosedInSetter();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        if (bytes instanceof HexDumpBytes) {
            offset &= 0xFFFFFFFFL;
        }
        super.bytesStore(bytes, offset, length);
    }

    @Override
    public long maxSize() {
        return 1L;
    }

    public boolean getValue() throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        byte b = this.bytes.readByte(this.offset);
        if (b == -80) {
            return false;
        }
        if (b == -79) {
            return true;
        }
        throw new IllegalStateException("unexpected code=" + b);
    }

    public void setValue(boolean flag) throws IllegalStateException {
        this.throwExceptionIfClosed();
        try {
            this.bytes.writeByte(this.offset, flag ? (byte)-79 : -80);
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }
}

