/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class CIDRPermissions {
    private static final CIDRPermissions ALL = new CIDRPermissions(){

        @Override
        public boolean canAccessFrom(Set<String> cidrGroup) {
            return true;
        }

        @Override
        public boolean restrictsAccess() {
            return false;
        }

        @Override
        public Set<String> allowedCIDRGroups() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "ALL";
        }

        @Override
        public void validate() {
        }
    };
    private static final CIDRPermissions NONE = new CIDRPermissions(){

        @Override
        public boolean canAccessFrom(Set<String> cidrGroup) {
            return false;
        }

        @Override
        public boolean restrictsAccess() {
            return true;
        }

        @Override
        public Set<String> allowedCIDRGroups() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "n/a";
        }

        @Override
        public void validate() {
            throw new UnsupportedOperationException();
        }
    };

    public abstract boolean canAccessFrom(Set<String> var1);

    public abstract boolean restrictsAccess();

    public abstract Set<String> allowedCIDRGroups();

    public abstract void validate();

    public static CIDRPermissions all() {
        return ALL;
    }

    public static CIDRPermissions none() {
        return NONE;
    }

    public static CIDRPermissions subset(Set<String> cidrGroups) {
        return new SubsetPermissions(cidrGroups);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<String> cidrGroups = new HashSet<String>();
        private boolean isAll = false;
        private boolean modified = false;

        public void add(String cidrGroup) {
            Preconditions.checkArgument(!this.isAll, "All has been set");
            this.cidrGroups.add(cidrGroup);
            this.modified = true;
        }

        public void all() {
            Preconditions.checkArgument(this.cidrGroups.isEmpty(), "CIDR Groups have already been set");
            this.isAll = true;
            this.modified = true;
        }

        public boolean isModified() {
            return this.modified;
        }

        public CIDRPermissions build() {
            if (this.cidrGroups.isEmpty()) {
                return CIDRPermissions.all();
            }
            return CIDRPermissions.subset(this.cidrGroups);
        }
    }

    private static class SubsetPermissions
    extends CIDRPermissions {
        private final Set<String> subset;

        public SubsetPermissions(Set<String> subset) {
            Preconditions.checkNotNull(subset);
            this.subset = subset;
        }

        @Override
        public boolean canAccessFrom(Set<String> cidrGroups) {
            return this.subset.stream().anyMatch(cidrGroups::contains);
        }

        @Override
        public boolean restrictsAccess() {
            return true;
        }

        @Override
        public Set<String> allowedCIDRGroups() {
            return ImmutableSet.copyOf(this.subset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubsetPermissions that = (SubsetPermissions)o;
            return this.subset.equals(that.subset);
        }

        public int hashCode() {
            return this.subset.hashCode();
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ");
            this.subset.forEach(joiner::add);
            return joiner.toString();
        }

        @Override
        public void validate() {
            Set<String> availableCidrGroups = DatabaseDescriptor.getCIDRAuthorizer().getCidrGroupsMappingManager().getAvailableCidrGroups();
            Sets.SetView<String> unknownCidrGroups = Sets.difference(this.subset, availableCidrGroups);
            if (!unknownCidrGroups.isEmpty()) {
                throw new InvalidRequestException("Invalid CIDR group(s): " + this.subset + ". Available CIDR Groups are: " + availableCidrGroups);
            }
        }
    }
}

