/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bitpack;

import java.io.IOException;
import org.apache.cassandra.index.sai.disk.v1.bitpack.AbstractBlockPackedWriter;
import org.apache.cassandra.index.sai.disk.v1.bitpack.MonotonicBlockPackedReader;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.packed.DirectWriter;

public class MonotonicBlockPackedWriter
extends AbstractBlockPackedWriter {
    public MonotonicBlockPackedWriter(IndexOutput out, int blockSize) {
        super(out, blockSize);
    }

    @Override
    public void add(long l) throws IOException {
        assert (l >= 0L);
        super.add(l);
    }

    @Override
    protected void flushBlock() throws IOException {
        float averageDelta = this.blockIndex == 1 ? 0.0f : (float)(this.blockValues[this.blockIndex - 1] - this.blockValues[0]) / (float)(this.blockIndex - 1);
        long minimumValue = this.blockValues[0];
        for (int index = 1; index < this.blockIndex; ++index) {
            long actual = this.blockValues[index];
            long expected = MonotonicBlockPackedReader.expected(minimumValue, averageDelta, index);
            if (expected <= actual) continue;
            minimumValue -= expected - actual;
        }
        long maxDelta = 0L;
        for (int i = 0; i < this.blockIndex; ++i) {
            this.blockValues[i] = this.blockValues[i] - MonotonicBlockPackedReader.expected(minimumValue, averageDelta, i);
            maxDelta = Math.max(maxDelta, this.blockValues[i]);
        }
        this.blockMetaWriter.writeZLong(minimumValue);
        this.blockMetaWriter.writeInt(Float.floatToIntBits(averageDelta));
        if (maxDelta == 0L) {
            this.blockMetaWriter.writeVInt(0);
        } else {
            int bitsRequired = DirectWriter.bitsRequired(maxDelta);
            this.blockMetaWriter.writeVInt(bitsRequired);
            this.blockMetaWriter.writeVLong(this.indexOutput.getFilePointer());
            this.writeValues(this.blockIndex, bitsRequired);
        }
    }
}

