/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.sai.utils.PartitionInfo;
import org.apache.cassandra.schema.TableMetadata;

public class InMemoryUnfilteredPartitionIterator
implements UnfilteredPartitionIterator {
    private final ReadCommand command;
    private final Iterator<Map.Entry<PartitionInfo, TreeSet<Unfiltered>>> partitions;

    public InMemoryUnfilteredPartitionIterator(ReadCommand command, TreeMap<PartitionInfo, TreeSet<Unfiltered>> rowsByPartitions) {
        this.command = command;
        this.partitions = rowsByPartitions.entrySet().iterator();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return this.partitions.hasNext();
    }

    @Override
    public UnfilteredRowIterator next() {
        return new InMemoryUnfilteredRowIterator(this.partitions.next());
    }

    @Override
    public TableMetadata metadata() {
        return this.command.metadata();
    }

    private class InMemoryUnfilteredRowIterator
    implements UnfilteredRowIterator {
        private final PartitionInfo partitionInfo;
        private final Iterator<Unfiltered> unfiltereds;

        public InMemoryUnfilteredRowIterator(Map.Entry<PartitionInfo, TreeSet<Unfiltered>> partition) {
            this.partitionInfo = partition.getKey();
            this.unfiltereds = partition.getValue().iterator();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.unfiltereds.hasNext();
        }

        @Override
        public Unfiltered next() {
            return this.unfiltereds.next();
        }

        @Override
        public TableMetadata metadata() {
            return InMemoryUnfilteredPartitionIterator.this.command.metadata();
        }

        @Override
        public boolean isReverseOrder() {
            return InMemoryUnfilteredPartitionIterator.this.command.isReversed();
        }

        @Override
        public RegularAndStaticColumns columns() {
            return InMemoryUnfilteredPartitionIterator.this.command.metadata().regularAndStaticColumns();
        }

        @Override
        public DecoratedKey partitionKey() {
            return this.partitionInfo.key;
        }

        @Override
        public Row staticRow() {
            return this.partitionInfo.staticRow;
        }

        @Override
        public DeletionTime partitionLevelDeletion() {
            return this.partitionInfo.partitionDeletion;
        }

        @Override
        public EncodingStats stats() {
            return this.partitionInfo.encodingStats;
        }
    }
}

