/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.api;

import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.cdc.api.CommitLogMarkers;
import org.apache.cassandra.cdc.api.Marker;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.jetbrains.annotations.NotNull;

public class PerInstanceCommitLogMarkers
implements CommitLogMarkers {
    final Map<CassandraInstance, Marker> markers;

    public PerInstanceCommitLogMarkers(Collection<Marker> markers1, Collection<Marker> markers2) {
        this(Stream.concat(markers1.stream(), markers2.stream()).collect(Collectors.toMap(Marker::instance, Function.identity(), Marker::min)));
    }

    public PerInstanceCommitLogMarkers(Map<CassandraInstance, Marker> markers) {
        this.markers = ImmutableMap.copyOf(markers);
    }

    @Override
    @NotNull
    public Marker startMarker(CassandraInstance instance) {
        return Optional.ofNullable(this.markers.get(instance)).orElseGet(instance::zeroMarker);
    }

    @Override
    public boolean canIgnore(Marker position, BigInteger token) {
        return false;
    }

    public int size() {
        return this.markers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.markers.isEmpty();
    }

    @Override
    public Collection<Marker> values() {
        return this.markers.values();
    }

    @Override
    public PerInstanceBuilder mutate() {
        return new PerInstanceBuilder(this.markers);
    }

    public int hashCode() {
        return Objects.hash(this.markers);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PerInstanceCommitLogMarkers rhs = (PerInstanceCommitLogMarkers)obj;
        return this.markers.equals(rhs.markers);
    }

    public String toString() {
        return "PerInstance{markers=" + String.valueOf(this.markers) + "}";
    }

    public static class PerInstanceBuilder {
        private final Map<CassandraInstance, Marker> markers;

        public PerInstanceBuilder() {
            this((Map<CassandraInstance, Marker>)ImmutableMap.of());
        }

        public PerInstanceBuilder(Map<CassandraInstance, Marker> markers) {
            this.markers = new HashMap<CassandraInstance, Marker>(markers);
        }

        public PerInstanceBuilder advanceMarker(CassandraInstance instance, Marker marker) {
            this.markers.compute(instance, (key, previous) -> {
                if (previous == null || marker.compareTo((Marker)previous) > 0) {
                    return marker;
                }
                return previous;
            });
            return this;
        }

        public PerInstanceCommitLogMarkers build() {
            return new PerInstanceCommitLogMarkers(this.markers);
        }
    }
}

