/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.kafka;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.cdc.CdcLogMode;
import org.apache.cassandra.cdc.TypeCache;
import org.apache.cassandra.cdc.api.KeyspaceTypeKey;
import org.apache.cassandra.cdc.kafka.EventHasher;
import org.apache.cassandra.cdc.kafka.KafkaStats;
import org.apache.cassandra.cdc.kafka.RecordProducer;
import org.apache.cassandra.cdc.kafka.TopicSupplier;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.Pair;
import org.apache.cassandra.spark.utils.Preconditions;
import org.apache.cassandra.spark.utils.TableIdentifier;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPublisher
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPublisher.class);
    protected TopicSupplier topicSupplier;
    protected int maxRecordSizeBytes;
    protected final RecordProducer recordProducer;
    protected final EventHasher eventHasher;
    protected boolean failOnRecordTooLargeError;
    protected boolean failOnKafkaError;
    protected CdcLogMode cdcLogMode;
    protected final AtomicReference<Throwable> failure = new AtomicReference();
    protected final KafkaProducer<String, byte[]> producer;
    protected final Serializer<CdcEvent> serializer;
    protected ThreadLocal<Map<Pair<String, String>, String>> prefixCache = ThreadLocal.withInitial(HashMap::new);
    protected final KafkaStats kafkaStats;

    public KafkaPublisher(TopicSupplier topicSupplier, KafkaProducer<String, byte[]> producer, Serializer<CdcEvent> serializer, int maxRecordSizeBytes, boolean failOnRecordTooLargeError, boolean failOnKafkaError, CdcLogMode logMode) {
        this(topicSupplier, producer, serializer, maxRecordSizeBytes, failOnRecordTooLargeError, failOnKafkaError, logMode, KafkaStats.STUB, RecordProducer.DEFAULT, EventHasher.MURMUR2);
    }

    public KafkaPublisher(TopicSupplier topicSupplier, KafkaProducer<String, byte[]> producer, Serializer<CdcEvent> serializer, int maxRecordSizeBytes, boolean failOnRecordTooLargeError, boolean failOnKafkaError, CdcLogMode logMode, KafkaStats kafkaStats, RecordProducer recordProducer, EventHasher eventHasher) {
        this.topicSupplier = topicSupplier;
        this.maxRecordSizeBytes = maxRecordSizeBytes;
        this.failOnRecordTooLargeError = failOnRecordTooLargeError;
        this.failOnKafkaError = failOnKafkaError;
        this.cdcLogMode = logMode;
        this.kafkaStats = kafkaStats;
        this.serializer = serializer;
        this.producer = producer;
        this.eventHasher = eventHasher;
        this.recordProducer = recordProducer;
        CdcLogMode.init(this::getType);
        kafkaStats.registerKafkaPublishErrorKpi();
    }

    public CqlField.CqlType getType(KeyspaceTypeKey key) {
        return TypeCache.get((CassandraVersion)this.version()).getType(key.keyspace, key.type);
    }

    public CassandraVersion version() {
        return CassandraVersion.FOURZERO;
    }

    public Logger logger() {
        return LOGGER;
    }

    protected RecordProducer recordProducer() {
        return this.recordProducer;
    }

    protected byte[] getPayload(String topic, CdcEvent event) {
        return this.serializer.serialize(topic, (Object)event);
    }

    public void processEvent(CdcEvent event) {
        byte[] recordPayload;
        String topic = this.topicSupplier.topic(event);
        this.cdcLogMode.info(this.logger(), "Processing CDC event", event, topic);
        long time = System.currentTimeMillis();
        try {
            recordPayload = this.getPayload(topic, event);
        }
        catch (Exception e) {
            this.cdcLogMode.warn(this.logger(), "Skip publishing the event because it cannot be serialized", event, topic, e);
            throw e;
        }
        String publishKey = this.getOrBuildKafkaPrefix(event) + this.eventHasher.hashEvent(event);
        List<ProducerRecord<String, byte[]>> records = this.recordProducer().buildRecords(event, topic, publishKey, recordPayload);
        for (ProducerRecord<String, byte[]> record : records) {
            this.producer.send(record, (metadata, throwable) -> {
                long elapsedTime = System.currentTimeMillis() - time;
                if (throwable != null) {
                    this.kafkaStats.reportKafkaPublishError();
                    if (throwable instanceof RecordTooLargeException) {
                        this.kafkaStats.reportKafkaRecordTooLarge();
                        this.cdcLogMode.error(this.logger(), "Kafka record too large exception", event, topic, throwable);
                        if (this.failOnRecordTooLargeError) {
                            this.failure.compareAndSet(null, throwable);
                        }
                    } else {
                        this.cdcLogMode.error(this.logger(), "Error publishing record to Kafka", event, topic, throwable);
                        if (this.failOnKafkaError) {
                            this.failure.compareAndSet(null, throwable);
                        }
                    }
                } else {
                    this.kafkaStats.changePublished(event);
                    this.logger().debug("Sent record(topic={}) meta(partition={}, offset={}) time={} topic={}", new Object[]{topic, metadata.partition(), metadata.offset(), elapsedTime, topic});
                }
            });
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    public void flush() throws InterruptedException {
        KafkaProducer<String, byte[]> producerRef = this.producer;
        if (producerRef == null) {
            return;
        }
        try {
            producerRef.flush();
            Throwable t = this.failure.get();
            if (t != null && this.failure.compareAndSet(t, null)) {
                this.kafkaStats.reportJobFailure();
                throw new RuntimeException(t);
            }
        }
        catch (InterruptException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedException();
        }
    }

    public void close(Throwable t) {
        if (t != null) {
            this.logger().error("Unexpected exception streaming rows", t);
        } else {
            this.logger().info("Closing streaming job");
        }
        if (this.producer != null) {
            this.producer.close();
        }
        if (this.serializer != null) {
            this.serializer.close();
        }
    }

    protected String getOrBuildKafkaPrefix(CdcEvent event) {
        return this.prefixCache.get().computeIfAbsent((Pair<String, String>)Pair.of((Object)event.keyspace, (Object)event.table), args -> String.format("%s:%s:", event.keyspace, event.table));
    }

    public static TableIdentifier extractTableIdFromPublishKey(String publishKey) {
        String[] components = publishKey.split(":");
        Preconditions.checkArgument((components.length == 3 ? 1 : 0) != 0);
        return TableIdentifier.of((String)components[0], (String)components[1]);
    }
}

