/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import o.a.c.sidecar.client.shaded.common.response.TokenRangeReplicasResponse;
import o.a.c.sidecar.client.shaded.common.response.data.RingEntry;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.common.model.NodeState;
import org.apache.cassandra.spark.common.model.NodeStatus;
import org.jetbrains.annotations.Nullable;

public class RingInstance
implements CassandraInstance,
Serializable {
    private static final long serialVersionUID = 4399143234683369652L;
    private RingEntry ringEntry;
    @Nullable
    private String clusterId;

    public RingInstance(TokenRangeReplicasResponse.ReplicaMetadata replica, @Nullable String clusterId) {
        this.clusterId = clusterId;
        this.ringEntry = new RingEntry.Builder().fqdn(replica.fqdn()).address(replica.address()).port(replica.port()).datacenter(replica.datacenter()).state(replica.state()).status(replica.status()).build();
    }

    @VisibleForTesting
    public RingInstance(RingEntry ringEntry) {
        this(ringEntry, null);
    }

    @VisibleForTesting
    public RingInstance(RingEntry ringEntry, @Nullable String clusterId) {
        this.clusterId = clusterId;
        this.ringEntry = ringEntry;
    }

    @VisibleForTesting
    public RingInstance(TokenRangeReplicasResponse.ReplicaMetadata replica) {
        this(replica, null);
    }

    public String token() {
        return this.ringEntry.token();
    }

    @Nullable
    public String clusterId() {
        return this.clusterId;
    }

    public String nodeName() {
        return this.ringEntry.fqdn();
    }

    public String datacenter() {
        return this.ringEntry.datacenter();
    }

    public String ipAddress() {
        return this.ringEntry.address();
    }

    public String ipAddressWithPort() {
        return this.ringEntry.address() + ":" + this.ringEntry.port();
    }

    public NodeState nodeState() {
        return NodeState.fromNameIgnoreCase((String)this.ringEntry.state());
    }

    public NodeStatus nodeStatus() {
        return NodeStatus.fromNameIgnoreCase((String)this.ringEntry.status());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RingInstance that = (RingInstance)other;
        return Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.ringEntry.token(), that.ringEntry.token()) && Objects.equals(this.ringEntry.fqdn(), that.ringEntry.fqdn()) && Objects.equals(this.ringEntry.rack(), that.ringEntry.rack()) && Objects.equals(this.ringEntry.address(), that.ringEntry.address()) && this.ringEntry.port() == that.ringEntry.port() && Objects.equals(this.ringEntry.datacenter(), that.ringEntry.datacenter());
    }

    public int hashCode() {
        return Objects.hash(this.clusterId, this.ringEntry.token(), this.ringEntry.fqdn(), this.ringEntry.rack(), this.ringEntry.port(), this.ringEntry.datacenter(), this.ringEntry.address());
    }

    public String toString() {
        return "RingInstance{cluster='" + this.clusterId + "', " + this.ringEntry.toString() + "}";
    }

    public RingEntry ringEntry() {
        return this.ringEntry;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.ringEntry.address());
        out.writeInt(this.ringEntry.port());
        out.writeUTF(this.ringEntry.datacenter());
        out.writeUTF(this.ringEntry.fqdn());
        out.writeUTF(this.ringEntry.status());
        out.writeUTF(this.ringEntry.state());
        out.writeObject(this.ringEntry.token());
        out.writeObject(this.ringEntry.rack());
        out.writeObject(this.ringEntry.hostId());
        out.writeObject(this.ringEntry.load());
        out.writeObject(this.ringEntry.owns());
        out.writeObject(this.clusterId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String address = in.readUTF();
        int port = in.readInt();
        String datacenter = in.readUTF();
        String fqdn = in.readUTF();
        String status = in.readUTF();
        String state = in.readUTF();
        String token = (String)in.readObject();
        String rack = (String)in.readObject();
        String hostId = (String)in.readObject();
        String load = (String)in.readObject();
        String owns = (String)in.readObject();
        String clusterId = (String)in.readObject();
        this.ringEntry = new RingEntry.Builder().datacenter(datacenter).address(address).port(port).status(status).state(state).token(token).fqdn(fqdn).rack(rack).hostId(hostId).load(load).owns(owns).build();
        this.clusterId = clusterId;
    }
}

