/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.cdc.api.Row;
import org.apache.cassandra.cql3.functions.types.CodecRegistry;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCqlType
implements CqlField.CqlType {
    public static final CodecRegistry CODEC_REGISTRY = new CodecRegistry();

    public CassandraVersion version() {
        return CassandraVersion.FOURZERO;
    }

    public abstract AbstractType<?> dataType();

    public abstract AbstractType<?> dataType(boolean var1);

    public Object deserializeToJavaType(ByteBuffer buffer, boolean isFrozen) {
        return this.serializer().deserialize(buffer);
    }

    public abstract <T> TypeSerializer<T> serializer();

    public ByteBuffer serialize(Object value) {
        return this.serializer().serialize(value);
    }

    public Object randomValue(int minCollectionSize) {
        throw CqlField.notImplemented((CqlField.CqlType)this);
    }

    public DataType driverDataType() {
        return this.driverDataType(false);
    }

    public DataType driverDataType(boolean isFrozen) {
        throw CqlField.notImplemented((CqlField.CqlType)this);
    }

    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, @NotNull Object value) {
        throw CqlField.notImplemented((CqlField.CqlType)this);
    }

    public final void setInnerValue(SettableByIndexData<?> udtValue, int position, @Nullable Object value) {
        if (value == null) {
            udtValue.setToNull(position);
        } else {
            this.setInnerValueInternal(udtValue, position, value);
        }
    }

    public String toString() {
        return this.cqlName();
    }

    public int cardinality(int orElse) {
        return orElse;
    }

    @VisibleForTesting
    protected static boolean isRowDeletion(CqlTable table, Row row) {
        return row.isDeleted();
    }

    @VisibleForTesting
    public void addCell(Row.Builder rowBuilder, ColumnMetadata cd, long timestamp, int ttl, int now, Object value) {
        this.addCell(rowBuilder, cd, timestamp, ttl, now, value, null);
    }

    @VisibleForTesting
    public void addCell(Row.Builder rowBuilder, ColumnMetadata cd, long timestamp, int ttl, int now, Object value, CellPath cellPath) {
        if (ttl != 0) {
            rowBuilder.addCell((Cell)BufferCell.expiring((ColumnMetadata)cd, (long)timestamp, (int)ttl, (int)now, (ByteBuffer)this.serialize(value), (CellPath)cellPath));
        } else {
            rowBuilder.addCell((Cell)BufferCell.live((ColumnMetadata)cd, (long)timestamp, (ByteBuffer)this.serialize(value), (CellPath)cellPath));
        }
    }

    @VisibleForTesting
    public void addTombstone(Row.Builder rowBuilder, ColumnMetadata cd, long timestamp) {
        Preconditions.checkArgument((!cd.isComplex() ? 1 : 0) != 0, (Object)"The method only works with non-complex columns");
        this.addTombstone(rowBuilder, cd, timestamp, null);
    }

    @VisibleForTesting
    public void addTombstone(Row.Builder rowBuilder, ColumnMetadata cd, long timestamp, CellPath cellPath) {
        Preconditions.checkArgument((!(cd.type instanceof ListType) ? 1 : 0) != 0, (Object)"The method does not support tombstone elements from a List type");
        rowBuilder.addCell((Cell)BufferCell.tombstone((ColumnMetadata)cd, (long)timestamp, (int)((int)TimeUnit.MICROSECONDS.toSeconds(timestamp)), (CellPath)cellPath));
    }

    @VisibleForTesting
    public void addComplexTombstone(Row.Builder rowBuilder, ColumnMetadata cd, long deletionTime) {
        Preconditions.checkArgument((boolean)cd.isComplex(), (Object)"The method only works with complex columns");
        rowBuilder.addComplexDeletion(cd, new DeletionTime(deletionTime, (int)TimeUnit.MICROSECONDS.toSeconds(deletionTime)));
    }
}

