/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.complex;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.cql3.functions.types.TupleHelper;
import org.apache.cassandra.cql3.functions.types.TupleValue;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.serializers.TupleSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.spark.data.AbstractCqlType;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlType;
import org.apache.cassandra.spark.data.TypeConverter;
import org.apache.cassandra.spark.data.complex.CqlCollection;
import org.apache.cassandra.spark.data.complex.CqlUdt;
import org.apache.cassandra.spark.utils.ByteBufferUtils;

public abstract class AbstractCqlTuple
extends CqlCollection
implements CqlField.CqlTuple {
    AbstractCqlTuple(CqlField.CqlType ... types) {
        super(types);
    }

    @Override
    public AbstractType<?> dataType(boolean isMultiCell) {
        return new TupleType(this.types().stream().map(type -> (CqlType)type).map(AbstractCqlType::dataType).collect(Collectors.toList()));
    }

    @Override
    public ByteBuffer serialize(Object value) {
        return this.serializeTuple((Object[])value);
    }

    @Override
    public <T> TypeSerializer<T> serializer() {
        return new TupleSerializer(this.types().stream().map(type -> (CqlType)type).map(AbstractCqlType::serializer).collect(Collectors.toList()));
    }

    public Object deserializeToType(TypeConverter typeConverter, ByteBuffer buffer, boolean isFrozen) {
        return typeConverter.convert((CqlField.CqlType)this, (Object)this.deserializeTuple(buffer, isFrozen), isFrozen);
    }

    @Override
    public Object deserializeToJavaType(ByteBuffer buffer, boolean isFrozen) {
        return this.deserializeTuple(buffer, isFrozen);
    }

    public CqlField.CqlType.InternalType internalType() {
        return CqlField.CqlType.InternalType.Tuple;
    }

    public String name() {
        return "tuple";
    }

    public ByteBuffer serializeTuple(Object[] values) {
        List buffers = IntStream.range(0, this.size()).mapToObj(index -> this.type(index).serialize(values[index])).collect(Collectors.toList());
        ByteBuffer result = ByteBuffer.allocate(buffers.stream().map(Buffer::remaining).map(remaining -> remaining + 4).reduce(Integer::sum).orElse(0));
        for (ByteBuffer buffer : buffers) {
            result.putInt(buffer.remaining());
            result.put(buffer.duplicate());
        }
        return result.flip();
    }

    public Object[] deserializeTuple(ByteBuffer buffer, boolean isFrozen) {
        Object[] result = new Object[this.size()];
        int position = 0;
        for (CqlField.CqlType type : this.types()) {
            if (buffer.remaining() < 4) break;
            int length = buffer.getInt();
            result[position++] = length > 0 ? type.deserializeToJavaType(ByteBufferUtils.readBytes((ByteBuffer)buffer, (int)length), isFrozen) : null;
        }
        return result;
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setTupleValue(position, AbstractCqlTuple.toTupleValue(this.getCassandraVersion(), this, value));
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return this.types().stream().map(type -> type.randomValue(minCollectionSize)).toArray();
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return TupleHelper.buildTupleType(this, isFrozen);
    }

    public Object convertForCqlWriter(Object value, CassandraVersion version, boolean isCollectionElement) {
        return AbstractCqlTuple.toTupleValue(version, this, value);
    }

    public static TupleValue toTupleValue(CassandraVersion version, AbstractCqlTuple tuple, Object value) {
        if (value instanceof TupleValue) {
            return (TupleValue)value;
        }
        TupleValue tupleValue = TupleHelper.buildTupleValue(tuple);
        Object[] array = (Object[])value;
        for (int position = 0; position < array.length; ++position) {
            CqlUdt.setNullableInnerValue(version, tupleValue, (CqlType)tuple.type(position), position, array[position]);
        }
        return tupleValue;
    }

    protected abstract CassandraVersion getCassandraVersion();
}

