/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.reflect.TypeToken;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.types.CodecRegistry;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.DataTypeClassNameParser;
import org.apache.cassandra.cql3.functions.types.TypeCodec;
import org.apache.cassandra.cql3.functions.types.exceptions.InvalidTypeException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.transport.ProtocolVersion;

public final class UDHelper {
    private static final CodecRegistry codecRegistry = new CodecRegistry();

    static TypeCodec<Object>[] codecsFor(DataType[] dataType) {
        TypeCodec[] codecs = new TypeCodec[dataType.length];
        for (int i = 0; i < dataType.length; ++i) {
            codecs[i] = UDHelper.codecFor(dataType[i]);
        }
        return codecs;
    }

    public static TypeCodec<Object> codecFor(DataType dataType) {
        return codecRegistry.codecFor(dataType);
    }

    public static TypeToken<?>[] typeTokens(TypeCodec<Object>[] dataTypes, boolean calledOnNullInput) {
        TypeToken[] paramTypes = new TypeToken[dataTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            TypeToken<Object> typeToken = dataTypes[i].getJavaType();
            if (!calledOnNullInput) {
                Class<Object> clazz = typeToken.getRawType();
                if (clazz == Integer.class) {
                    typeToken = TypeToken.of(Integer.TYPE);
                } else if (clazz == Long.class) {
                    typeToken = TypeToken.of(Long.TYPE);
                } else if (clazz == Byte.class) {
                    typeToken = TypeToken.of(Byte.TYPE);
                } else if (clazz == Short.class) {
                    typeToken = TypeToken.of(Short.TYPE);
                } else if (clazz == Float.class) {
                    typeToken = TypeToken.of(Float.TYPE);
                } else if (clazz == Double.class) {
                    typeToken = TypeToken.of(Double.TYPE);
                } else if (clazz == Boolean.class) {
                    typeToken = TypeToken.of(Boolean.TYPE);
                }
            }
            paramTypes[i] = typeToken;
        }
        return paramTypes;
    }

    public static DataType[] driverTypes(List<AbstractType<?>> abstractTypes) {
        DataType[] argDataTypes = new DataType[abstractTypes.size()];
        for (int i = 0; i < argDataTypes.length; ++i) {
            argDataTypes[i] = UDHelper.driverType(abstractTypes.get(i));
        }
        return argDataTypes;
    }

    public static DataType driverType(AbstractType abstractType) {
        CQL3Type cqlType = abstractType.asCQL3Type();
        String abstractTypeDef = cqlType.getType().toString();
        return UDHelper.driverTypeFromAbstractType(abstractTypeDef);
    }

    public static DataType driverTypeFromAbstractType(String abstractTypeDef) {
        return DataTypeClassNameParser.parseOne(abstractTypeDef, ProtocolVersion.CURRENT, codecRegistry);
    }

    public static Object deserialize(TypeCodec<?> codec, ProtocolVersion protocolVersion, ByteBuffer value) {
        return codec.deserialize(value, protocolVersion);
    }

    public static ByteBuffer serialize(TypeCodec<?> codec, ProtocolVersion protocolVersion, Object value) {
        if (!codec.getJavaType().getRawType().isAssignableFrom(value.getClass())) {
            throw new InvalidTypeException("Invalid value for CQL type " + (Object)((Object)codec.getCqlType().getName()));
        }
        return codec.serialize(value, protocolVersion);
    }

    public static Class<?> asJavaClass(TypeCodec<?> codec) {
        return codec.getJavaType().getRawType();
    }

    public static boolean isNullOrEmpty(AbstractType<?> type, ByteBuffer bb) {
        return bb == null || bb.remaining() == 0 && type.isEmptyValueMeaningless();
    }
}

