/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.cassandra.utils.EstimatedHistogram;

public class DecayingEstimatedHistogramReservoir
implements Reservoir {
    public static final int DEFAULT_BUCKET_COUNT = 164;
    public static final int DEFAULT_STRIPE_COUNT = Integer.parseInt(System.getProperty("cassandra.dehr_stripe_count", "2"));
    public static final int MAX_BUCKET_COUNT = 237;
    public static final boolean DEFAULT_ZERO_CONSIDERATION = false;
    private static final int[] DISTRIBUTION_PRIMES = new int[]{17, 19, 23, 29};
    public static final long[] DEFAULT_WITHOUT_ZERO_BUCKET_OFFSETS = EstimatedHistogram.newOffsets(164, false);
    public static final long[] DEFAULT_WITH_ZERO_BUCKET_OFFSETS = EstimatedHistogram.newOffsets(164, true);
    private static final int TABLE_BITS = 4;
    private static final int TABLE_MASK = 15;
    private static final float[] LOG2_TABLE = DecayingEstimatedHistogramReservoir.computeTable(4);
    private static final float log2_12_recp = (float)(1.0 / DecayingEstimatedHistogramReservoir.slowLog2(1.2));
    private final int nStripes;
    private final long[] bucketOffsets;
    private final int distributionPrime;
    private final AtomicLongArray decayingBuckets;
    private final AtomicLongArray buckets;
    public static final long HALF_TIME_IN_S = 60L;
    public static final double MEAN_LIFETIME_IN_S = 60.0 / Math.log(2.0);
    public static final long LANDMARK_RESET_INTERVAL_IN_MS = 1800000L;
    private final AtomicBoolean rescaling = new AtomicBoolean(false);
    private volatile long decayLandmark;
    private final Clock clock;

    private static float[] computeTable(int bits) {
        float[] table = new float[1 << bits];
        for (int i = 1; i < 1 << bits; ++i) {
            table[i] = (float)DecayingEstimatedHistogramReservoir.slowLog2(DecayingEstimatedHistogramReservoir.ratio(i, bits));
        }
        return table;
    }

    public static float fastLog12(long v) {
        return DecayingEstimatedHistogramReservoir.fastLog2(v) * log2_12_recp;
    }

    private static float fastLog2(long v) {
        v = Math.max(v, 1L);
        int highestBitPosition = 63 - Long.numberOfLeadingZeros(v);
        v = Long.rotateRight(v, highestBitPosition - 4);
        int index = (int)(v & 0xFL);
        float result = LOG2_TABLE[index];
        return result += (float)highestBitPosition;
    }

    private static double slowLog2(double v) {
        return Math.log(v) / Math.log(2.0);
    }

    private static double ratio(int i, int bits) {
        return Float.intBitsToFloat(0x3F800000 | i << 23 - bits);
    }

    public DecayingEstimatedHistogramReservoir() {
        this(false, 164, DEFAULT_STRIPE_COUNT, Clock.defaultClock());
    }

    public DecayingEstimatedHistogramReservoir(boolean considerZeroes) {
        this(considerZeroes, 164, DEFAULT_STRIPE_COUNT, Clock.defaultClock());
    }

    public DecayingEstimatedHistogramReservoir(boolean considerZeroes, int bucketCount, int stripes) {
        this(considerZeroes, bucketCount, stripes, Clock.defaultClock());
    }

    @VisibleForTesting
    public DecayingEstimatedHistogramReservoir(Clock clock) {
        this(false, 164, DEFAULT_STRIPE_COUNT, clock);
    }

    @VisibleForTesting
    DecayingEstimatedHistogramReservoir(boolean considerZeroes, int bucketCount, int stripes, Clock clock) {
        assert (bucketCount <= 237) : "bucket count cannot exceed: 237";
        this.bucketOffsets = bucketCount == 164 ? (considerZeroes ? DEFAULT_WITH_ZERO_BUCKET_OFFSETS : DEFAULT_WITHOUT_ZERO_BUCKET_OFFSETS) : EstimatedHistogram.newOffsets(bucketCount, considerZeroes);
        this.nStripes = stripes;
        this.decayingBuckets = new AtomicLongArray((this.bucketOffsets.length + 1) * this.nStripes);
        this.buckets = new AtomicLongArray((this.bucketOffsets.length + 1) * this.nStripes);
        this.clock = clock;
        this.decayLandmark = clock.getTime();
        int distributionPrime = 1;
        for (int prime : DISTRIBUTION_PRIMES) {
            if (this.buckets.length() % prime == 0) continue;
            distributionPrime = prime;
            break;
        }
        this.distributionPrime = distributionPrime;
    }

    @Override
    public void update(long value) {
        long now = this.clock.getTime();
        this.rescaleIfNeeded(now);
        int index = DecayingEstimatedHistogramReservoir.findIndex(this.bucketOffsets, value);
        this.updateBucket(this.decayingBuckets, index, Math.round(this.forwardDecayWeight(now)));
        this.updateBucket(this.buckets, index, 1L);
    }

    public void updateBucket(AtomicLongArray buckets, int index, long value) {
        int stripe = (int)(Thread.currentThread().getId() & (long)(this.nStripes - 1));
        buckets.addAndGet(this.stripedIndex(index, stripe), value);
    }

    public int stripedIndex(int offsetIndex, int stripe) {
        return (offsetIndex * this.nStripes + stripe) * this.distributionPrime % this.buckets.length();
    }

    @VisibleForTesting
    public static int findIndex(long[] bucketOffsets, long value) {
        int offset = ((value = Math.max(value, 0L)) > 2L ? 3 : 1) + (int)bucketOffsets[0];
        int firstCandidate = Math.max(0, Math.min(bucketOffsets.length - 1, (int)DecayingEstimatedHistogramReservoir.fastLog12(value) - offset));
        return value <= bucketOffsets[firstCandidate] ? firstCandidate : firstCandidate + 1;
    }

    private double forwardDecayWeight(long now) {
        return Math.exp((double)(now - this.decayLandmark) / 1000.0 / MEAN_LIFETIME_IN_S);
    }

    @Override
    public int size() {
        return this.bucketOffsets.length + 1;
    }

    public int stripeCount() {
        return this.nStripes;
    }

    @Override
    public Snapshot getSnapshot() {
        this.rescaleIfNeeded();
        return new EstimatedHistogramReservoirSnapshot(this);
    }

    @VisibleForTesting
    boolean isOverflowed() {
        return this.bucketValue(this.bucketOffsets.length, true) > 0L;
    }

    private long bucketValue(int index, boolean withDecay) {
        long val = 0L;
        AtomicLongArray bs = withDecay ? this.decayingBuckets : this.buckets;
        for (int stripe = 0; stripe < this.nStripes; ++stripe) {
            val += bs.get(this.stripedIndex(index, stripe));
        }
        return val;
    }

    @VisibleForTesting
    long stripedBucketValue(int i, boolean withDecay) {
        return withDecay ? this.decayingBuckets.get(i) : this.buckets.get(i);
    }

    private void rescaleIfNeeded() {
        this.rescaleIfNeeded(this.clock.getTime());
    }

    private void rescaleIfNeeded(long now) {
        if (this.needRescale(now) && this.rescaling.compareAndSet(false, true)) {
            try {
                this.rescale(now);
            }
            finally {
                this.decayLandmark = now;
                this.rescaling.set(false);
            }
        }
    }

    private void rescale(long now) {
        double rescaleFactor = this.forwardDecayWeight(now);
        for (int i = 0; i < this.decayingBuckets.length(); ++i) {
            long newValue = Math.round((double)this.decayingBuckets.get(i) / rescaleFactor);
            this.decayingBuckets.set(i, newValue);
        }
    }

    private boolean needRescale(long now) {
        return now - this.decayLandmark > 1800000L;
    }

    @VisibleForTesting
    public void clear() {
        int bucketCount = this.decayingBuckets.length();
        for (int i = 0; i < bucketCount; ++i) {
            this.decayingBuckets.set(i, 0L);
            this.buckets.set(i, 0L);
        }
    }

    public void rebase(EstimatedHistogramReservoirSnapshot snapshot) {
        int i;
        if (this.size() != snapshot.decayingBuckets.length) {
            throw new IllegalStateException("Unable to merge two DecayingEstimatedHistogramReservoirs with different bucket sizes");
        }
        for (i = 0; i < this.bucketOffsets.length; ++i) {
            if (this.bucketOffsets[i] == snapshot.bucketOffsets[i]) continue;
            throw new IllegalStateException("Merge is only supported with equal bucketOffsets");
        }
        this.decayLandmark = snapshot.snapshotLandmark;
        for (i = 0; i < this.size(); ++i) {
            this.decayingBuckets.set(this.stripedIndex(i, 0), snapshot.decayingBuckets[i]);
            this.buckets.set(this.stripedIndex(i, 0), snapshot.values[i]);
            for (int stripe = 1; stripe < this.nStripes; ++stripe) {
                this.decayingBuckets.set(this.stripedIndex(i, stripe), 0L);
                this.buckets.set(this.stripedIndex(i, stripe), 0L);
            }
        }
    }

    static class Range {
        public final long min;
        public final long max;

        public Range(long min2, long max) {
            this.min = min2;
            this.max = max;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range that = (Range)o;
            return this.min == that.min && this.max == that.max;
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max);
        }
    }

    static class EstimatedHistogramReservoirSnapshot
    extends Snapshot {
        private final long[] decayingBuckets;
        private final long[] values;
        private long count;
        private long snapshotLandmark;
        private long[] bucketOffsets;
        private DecayingEstimatedHistogramReservoir reservoir;

        public EstimatedHistogramReservoirSnapshot(DecayingEstimatedHistogramReservoir reservoir) {
            int length = reservoir.size();
            double rescaleFactor = reservoir.forwardDecayWeight(reservoir.clock.getTime());
            this.decayingBuckets = new long[length];
            this.values = new long[length];
            this.snapshotLandmark = reservoir.decayLandmark;
            this.bucketOffsets = reservoir.bucketOffsets;
            for (int i = 0; i < length; ++i) {
                this.decayingBuckets[i] = Math.round((double)reservoir.bucketValue(i, true) / rescaleFactor);
                this.values[i] = reservoir.bucketValue(i, false);
            }
            this.count = this.count();
            this.reservoir = reservoir;
        }

        @Override
        public double getValue(double quantile) {
            assert (quantile >= 0.0 && quantile <= 1.0);
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                throw new IllegalStateException("Unable to compute when histogram overflowed");
            }
            long qcount = (long)Math.ceil((double)this.count() * quantile);
            if (qcount == 0L) {
                return 0.0;
            }
            long elements = 0L;
            for (int i = 0; i < lastBucket; ++i) {
                if ((elements += this.decayingBuckets[i]) < qcount) continue;
                return this.bucketOffsets[i];
            }
            return 0.0;
        }

        @Override
        public long[] getValues() {
            return this.values;
        }

        @Override
        public int size() {
            return Ints.saturatedCast(this.count);
        }

        @VisibleForTesting
        public long getSnapshotLandmark() {
            return this.snapshotLandmark;
        }

        @VisibleForTesting
        public Range getBucketingRangeForValue(long value) {
            int index = DecayingEstimatedHistogramReservoir.findIndex(this.bucketOffsets, value);
            long max = this.bucketOffsets[index];
            long min2 = index == 0 ? 0L : 1L + this.bucketOffsets[index - 1];
            return new Range(min2, max);
        }

        private long count() {
            long sum = 0L;
            for (int i = 0; i < this.decayingBuckets.length; ++i) {
                sum += this.decayingBuckets[i];
            }
            return sum;
        }

        @Override
        public long getMax() {
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                return Long.MAX_VALUE;
            }
            for (int i = lastBucket - 1; i >= 0; --i) {
                if (this.decayingBuckets[i] <= 0L) continue;
                return this.bucketOffsets[i];
            }
            return 0L;
        }

        @Override
        public double getMean() {
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                throw new IllegalStateException("Unable to compute when histogram overflowed");
            }
            long elements = 0L;
            long sum = 0L;
            for (int i = 0; i < lastBucket; ++i) {
                long bCount = this.decayingBuckets[i];
                elements += bCount;
                sum += bCount * this.bucketOffsets[i];
            }
            return (double)sum / (double)elements;
        }

        @Override
        public long getMin() {
            for (int i = 0; i < this.decayingBuckets.length; ++i) {
                if (this.decayingBuckets[i] <= 0L) continue;
                return i == 0 ? 0L : 1L + this.bucketOffsets[i - 1];
            }
            return 0L;
        }

        @Override
        public double getStdDev() {
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                throw new IllegalStateException("Unable to compute when histogram overflowed");
            }
            long count = this.count();
            if (count <= 1L) {
                return 0.0;
            }
            double mean = this.getMean();
            double sum = 0.0;
            for (int i = 0; i < lastBucket; ++i) {
                long value = this.bucketOffsets[i];
                double diff = (double)value - mean;
                sum += diff * diff * (double)this.decayingBuckets[i];
            }
            return Math.sqrt(sum / (double)(count - 1L));
        }

        @Override
        public void dump(OutputStream output) {
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
                int length = this.decayingBuckets.length;
                for (int i = 0; i < length; ++i) {
                    out.printf("%d%n", this.decayingBuckets[i]);
                }
            }
        }

        public void add(Snapshot other) {
            int i;
            if (!(other instanceof EstimatedHistogramReservoirSnapshot)) {
                throw new IllegalStateException("Unable to add other types of Snapshot than another DecayingEstimatedHistogramReservoir");
            }
            EstimatedHistogramReservoirSnapshot snapshot = (EstimatedHistogramReservoirSnapshot)other;
            if (this.decayingBuckets.length != snapshot.decayingBuckets.length) {
                throw new IllegalStateException("Unable to merge two DecayingEstimatedHistogramReservoirs with different bucket sizes");
            }
            for (i = 0; i < this.bucketOffsets.length; ++i) {
                if (this.bucketOffsets[i] == snapshot.bucketOffsets[i]) continue;
                throw new IllegalStateException("Merge is only supported with equal bucketOffsets");
            }
            if (snapshot.snapshotLandmark < this.snapshotLandmark) {
                this.rescaleArray(snapshot.decayingBuckets, this.snapshotLandmark - snapshot.snapshotLandmark);
            } else if (snapshot.snapshotLandmark > this.snapshotLandmark) {
                this.rescaleArray(this.decayingBuckets, snapshot.snapshotLandmark - this.snapshotLandmark);
                this.snapshotLandmark = snapshot.snapshotLandmark;
            }
            for (i = 0; i < snapshot.decayingBuckets.length; ++i) {
                int n = i;
                this.decayingBuckets[n] = this.decayingBuckets[n] + snapshot.decayingBuckets[i];
                int n2 = i;
                this.values[n2] = this.values[n2] + snapshot.values[i];
            }
            this.count += snapshot.count;
        }

        private void rescaleArray(long[] decayingBuckets, long landMarkDifference) {
            double rescaleFactor = Math.exp((double)landMarkDifference / 1000.0 / MEAN_LIFETIME_IN_S);
            for (int i = 0; i < decayingBuckets.length; ++i) {
                decayingBuckets[i] = Math.round((double)decayingBuckets[i] / rescaleFactor);
            }
        }

        public void rebaseReservoir() {
            this.reservoir.rebase(this);
        }
    }
}

