/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.datastax.driver.core.TableMetadata;
import com.linkedin.common.BrowsePaths;
import com.linkedin.data.template.StringArray;
import datahub.event.MetadataChangeProposalWrapper;
import org.apache.cassandra.sidecar.datahub.IdentifiersProvider;
import org.apache.cassandra.sidecar.datahub.TableToAspectConverter;
import org.jetbrains.annotations.NotNull;

public class TableToBrowsePathsConverter
extends TableToAspectConverter<BrowsePaths> {
    protected static final String PROD = "prod";

    public TableToBrowsePathsConverter(@NotNull IdentifiersProvider identifiers) {
        super(identifiers);
    }

    @Override
    @NotNull
    public MetadataChangeProposalWrapper<BrowsePaths> convert(@NotNull TableMetadata table) {
        String urn = this.identifiers.urnDataset(table);
        String path = String.format("/%s/%s/%s/%s/%s/%s/", PROD, this.identifiers.platform(), this.identifiers.environment(), this.identifiers.application(), this.identifiers.cluster(), table.getKeyspace().getName());
        BrowsePaths aspect = new BrowsePaths().setPaths(new StringArray(path, new String[0]));
        return this.wrap(urn, aspect);
    }
}

