/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.ArrayConverter;
import org.apache.commons.beanutils2.converters.DateConverter;
import org.apache.commons.beanutils2.converters.IntegerConverter;
import org.apache.commons.beanutils2.converters.StringConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ArrayConverterTest {
    private void checkArray(String msg, Object expected, Object result) {
        Assertions.assertNotNull((Object)expected, (String)(msg + " Expected Null"));
        Assertions.assertNotNull((Object)result, (String)(msg + " Result   Null"));
        Assertions.assertTrue((boolean)result.getClass().isArray(), (String)(msg + " Result   not array"));
        Assertions.assertTrue((boolean)expected.getClass().isArray(), (String)(msg + " Expected not array"));
        int resultLth = Array.getLength(result);
        Assertions.assertEquals((int)Array.getLength(expected), (int)resultLth, (String)(msg + " Size"));
        Assertions.assertEquals(expected.getClass(), result.getClass(), (String)(msg + " Type"));
        for (int i = 0; i < resultLth; ++i) {
            Object expectElement = Array.get(expected, i);
            Object resultElement = Array.get(result, i);
            Assertions.assertEquals((Object)expectElement, (Object)resultElement, (String)(msg + " Element " + i));
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testComponentIntegerConverter() {
        IntegerConverter intConverter = new IntegerConverter(Integer.valueOf(0));
        intConverter.setPattern("#,###");
        intConverter.setLocale(Locale.US);
        ArrayConverter arrayConverter = new ArrayConverter(int[].class, (Converter)intConverter, 0);
        arrayConverter.setAllowedChars(new char[]{',', '-'});
        arrayConverter.setDelimiter(';');
        int[] intArray = new int[]{1111, 2222, 3333, 4444};
        String stringA = "1,111; 2,222; 3,333; 4,444";
        String stringB = intArray[0] + ";" + intArray[1] + ";" + intArray[2] + ";" + intArray[3];
        String[] strArray = new String[]{"" + intArray[0], "" + intArray[1], "" + intArray[2], "" + intArray[3]};
        long[] longArray = new long[]{intArray[0], intArray[1], intArray[2], intArray[3]};
        Long[] LONGArray = new Long[]{intArray[0], intArray[1], intArray[2], intArray[3]};
        Integer[] IntegerArray = new Integer[]{intArray[0], intArray[1], intArray[2], intArray[3]};
        ArrayList<String> strList = new ArrayList<String>();
        ArrayList<Long> longList = new ArrayList<Long>();
        for (int i = 0; i < strArray.length; ++i) {
            strList.add(strArray[i]);
            longList.add(LONGArray[i]);
        }
        String msg = null;
        msg = "String --> int[]";
        this.checkArray(msg, intArray, arrayConverter.convert(int[].class, (Object)"1,111; 2,222; 3,333; 4,444"));
        msg = "String --> Integer[] (with braces)";
        this.checkArray(msg, IntegerArray, arrayConverter.convert(Integer[].class, (Object)"{1,111; 2,222; 3,333; 4,444}"));
        msg = "String[] --> int[]";
        this.checkArray(msg, intArray, arrayConverter.convert(int[].class, (Object)strArray));
        msg = "String[] --> Integer[]";
        this.checkArray(msg, IntegerArray, arrayConverter.convert(Integer[].class, (Object)strArray));
        msg = "long[] --> int[]";
        this.checkArray(msg, intArray, arrayConverter.convert(int[].class, (Object)longArray));
        msg = "Long --> int[]";
        this.checkArray(msg, new int[]{LONGArray[0].intValue()}, arrayConverter.convert(int[].class, (Object)LONGArray[0]));
        msg = "LONG[] --> int[]";
        this.checkArray(msg, intArray, arrayConverter.convert(int[].class, (Object)LONGArray));
        msg = "Long --> String";
        Assertions.assertEquals((Object)(LONGArray[0] + ""), (Object)arrayConverter.convert(String.class, (Object)LONGArray[0]), (String)msg);
        msg = "LONG[] --> String (first)";
        Assertions.assertEquals((Object)(LONGArray[0] + ""), (Object)arrayConverter.convert(String.class, (Object)LONGArray), (String)msg);
        msg = "LONG[] --> String (all)";
        arrayConverter.setOnlyFirstToString(false);
        Assertions.assertEquals((Object)stringB, (Object)arrayConverter.convert(String.class, (Object)LONGArray), (String)msg);
        msg = "Collection of Long --> String";
        Assertions.assertEquals((Object)stringB, (Object)arrayConverter.convert(String.class, longList), (String)msg);
        msg = "long[] --> String[]";
        this.checkArray(msg, strArray, arrayConverter.convert(String[].class, (Object)LONGArray));
        msg = "Collection of String --> Integer[]";
        this.checkArray(msg, IntegerArray, arrayConverter.convert(Integer[].class, strList));
        msg = "Collection of Long --> int[]";
        this.checkArray(msg, intArray, arrayConverter.convert(int[].class, longList));
    }

    @Test
    public void testEmptyString() {
        int[] zeroArray = new int[]{};
        IntegerConverter intConverter = new IntegerConverter();
        this.checkArray("Empty String", zeroArray, new ArrayConverter(int[].class, (Converter)intConverter, -1).convert(int[].class, (Object)""));
        Assertions.assertEquals(null, (Object)new ArrayConverter(int[].class, (Converter)intConverter).convert(String.class, null), (String)"Default String");
    }

    @Test
    public void testErrors() {
        Assertions.assertThrows(NullPointerException.class, () -> new ArrayConverter(null, (Converter)new DateConverter()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ArrayConverter(Boolean.class, (Converter)new DateConverter()));
        Assertions.assertThrows(NullPointerException.class, () -> new ArrayConverter(int[].class, null));
    }

    @Test
    public void testInvalidWithDefault() {
        int[] zeroArray = new int[]{};
        int[] oneArray = new int[1];
        IntegerConverter intConverter = new IntegerConverter();
        Assertions.assertEquals(null, (Object)new ArrayConverter(int[].class, (Converter)intConverter, -1).convert(int[].class, null), (String)"Null Default");
        this.checkArray("Zero Length", zeroArray, new ArrayConverter(int[].class, (Converter)intConverter, 0).convert(int[].class, null));
        this.checkArray("One Length", oneArray, new ArrayConverter(Integer[].class, (Converter)intConverter, 1).convert(int[].class, null));
    }

    @Test
    public void testStringArrayToNumber() {
        IntegerConverter intConverter = new IntegerConverter();
        ArrayConverter arrayConverter = new ArrayConverter(int[].class, (Converter)intConverter);
        String[] array = new String[]{"10", "  11", "12  ", "  13  "};
        ArrayList list = new ArrayList();
        Collections.addAll(list, array);
        String msg = null;
        int[] expectedInt = new int[]{10, 11, 12, 13};
        Integer[] expectedInteger = new Integer[]{expectedInt[0], expectedInt[1], expectedInt[2], expectedInt[3]};
        msg = "String[] --> int[]";
        this.checkArray(msg, expectedInt, arrayConverter.convert(int[].class, (Object)array));
        msg = "String[] --> Integer[]";
        this.checkArray(msg, expectedInteger, arrayConverter.convert(Integer[].class, (Object)array));
        msg = "List --> int[]";
        this.checkArray(msg, expectedInt, arrayConverter.convert(int[].class, list));
        msg = "List --> Integer[]";
        this.checkArray(msg, expectedInteger, arrayConverter.convert(Integer[].class, list));
    }

    @Test
    public void testTheMatrix() {
        String matrixString = "11,12,13 ; 21,22,23 ; 31,32,33 ; 41,42,43";
        int[][] expected = new int[][]{{11, 12, 13}, {21, 22, 23}, {31, 32, 33}, {41, 42, 43}};
        IntegerConverter integerConverter = new IntegerConverter();
        ArrayConverter arrayConverter = new ArrayConverter(int[].class, (Converter)integerConverter);
        ArrayConverter matrixConverter = new ArrayConverter(int[][].class, (Converter)arrayConverter);
        matrixConverter.setDelimiter(';');
        matrixConverter.setAllowedChars(new char[]{','});
        Object result = matrixConverter.convert(int[][].class, (Object)"11,12,13 ; 21,22,23 ; 31,32,33 ; 41,42,43");
        Assertions.assertEquals(int[][].class, result.getClass(), (String)"Check int[][].class");
        int[][] matrix = (int[][])result;
        Assertions.assertEquals((int)expected.length, (int)matrix.length, (String)"Check int[][] length");
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((int)expected[i].length, (int)matrix[i].length, (String)("Check int[" + i + "] length"));
            for (int j = 0; j < expected[i].length; ++j) {
                String label = "Matrix int[" + i + "," + j + "] element";
                Assertions.assertEquals((int)expected[i][j], (int)matrix[i][j], (String)label);
            }
        }
    }

    @Test
    public void testUnderscore_BEANUTILS_302() {
        String value = "first_value,second_value";
        ArrayConverter converter = new ArrayConverter(String[].class, (Converter)new StringConverter());
        String[] result = (String[])converter.convert(String[].class, (Object)"first_value,second_value");
        Assertions.assertNotNull((Object)result, (String)"result.null");
        Assertions.assertEquals((int)4, (int)result.length, (String)"result.length");
        Assertions.assertEquals((Object)"first", (Object)result[0], (String)"result[0]");
        Assertions.assertEquals((Object)"value", (Object)result[1], (String)"result[1]");
        Assertions.assertEquals((Object)"second", (Object)result[2], (String)"result[2]");
        Assertions.assertEquals((Object)"value", (Object)result[3], (String)"result[3]");
        converter.setAllowedChars(new char[]{'.', '-', '_'});
        result = (String[])converter.convert(String[].class, (Object)"first_value,second_value");
        Assertions.assertNotNull((Object)result, (String)"result.null");
        Assertions.assertEquals((int)2, (int)result.length, (String)"result.length");
        Assertions.assertEquals((Object)"first_value", (Object)result[0], (String)"result[0]");
        Assertions.assertEquals((Object)"second_value", (Object)result[1], (String)"result[1]");
    }
}

