/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.AbstractCellExtractorTest;
import org.apache.commons.collections4.bloomfilter.ArrayCountingBloomFilter;
import org.apache.commons.collections4.bloomfilter.CellExtractor;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.Shape;

public class CellExtractorFromArrayCountingBloomFilterTest
extends AbstractCellExtractorTest {
    protected Shape shape = Shape.fromKM((int)17, (int)72);

    @Override
    protected CellExtractor createEmptyExtractor() {
        return new ArrayCountingBloomFilter(this.shape);
    }

    @Override
    protected CellExtractor createExtractor() {
        ArrayCountingBloomFilter filter = new ArrayCountingBloomFilter(this.shape);
        filter.merge((Hasher)new IncrementingHasher(0L, 1L));
        filter.merge((Hasher)new IncrementingHasher(5L, 1L));
        return filter;
    }

    @Override
    protected int[] getExpectedIndices() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    }

    @Override
    protected int[] getExpectedValues() {
        return new int[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1};
    }
}

