/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.ResettableListIterator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ListIteratorWrapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ListIteratorWrapperTest<E>
extends AbstractIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
    protected List<E> list1;

    @Override
    public ResettableListIterator<E> makeEmptyIterator() {
        ArrayList list = new ArrayList();
        return new ListIteratorWrapper(list.iterator());
    }

    @Override
    public ResettableListIterator<E> makeObject() {
        return new ListIteratorWrapper(this.list1.iterator());
    }

    @BeforeEach
    public void setUp() {
        this.list1 = new ArrayList();
        this.list1.add("One");
        this.list1.add("Two");
        this.list1.add("Three");
        this.list1.add("Four");
        this.list1.add("Five");
        this.list1.add("Six");
    }

    @Test
    public void testIterator() {
        Object iterValue;
        ResettableListIterator<E> iter = this.makeObject();
        for (String testValue : this.testArray) {
            iterValue = iter.next();
            Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        }
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Iterator should now be empty");
        Assertions.assertThrows(NoSuchElementException.class, () -> iter.next());
        for (int i = this.testArray.length - 1; i > -1; --i) {
            String testValue = this.testArray[i];
            Object iterValue2 = iter.previous();
            Assertions.assertEquals((Object)testValue, iterValue2, (String)"Iteration value is correct");
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> iter.previous());
        for (String testValue : this.testArray) {
            iterValue = iter.next();
            Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        }
    }

    @Override
    @Test
    public void testRemove() {
        ResettableListIterator iter = this.makeObject();
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        Assertions.assertThrows(IllegalStateException.class, () -> iter.remove(), (String)"ListIteratorWrapper#remove() should fail; must be initially positioned first");
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        int sz = this.list1.size();
        Assertions.assertEquals(this.list1.get(0), iter.next());
        Assertions.assertEquals((int)0, (int)iter.previousIndex());
        Assertions.assertEquals((int)1, (int)iter.nextIndex());
        iter.remove();
        Assertions.assertEquals((int)(--sz), (int)this.list1.size());
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        Assertions.assertThrows(IllegalStateException.class, () -> iter.remove(), (String)"ListIteratorWrapper#remove() should fail; must be repositioned first");
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        Assertions.assertEquals(this.list1.get(0), iter.next());
        Assertions.assertEquals((int)0, (int)iter.previousIndex());
        Assertions.assertEquals((int)1, (int)iter.nextIndex());
        Assertions.assertEquals(this.list1.get(1), iter.next());
        Assertions.assertEquals((int)1, (int)iter.previousIndex());
        Assertions.assertEquals((int)2, (int)iter.nextIndex());
        Assertions.assertEquals(this.list1.get(1), iter.previous());
        Assertions.assertEquals((int)0, (int)iter.previousIndex());
        Assertions.assertEquals((int)1, (int)iter.nextIndex());
        iter.remove();
        Assertions.assertEquals((int)(--sz), (int)this.list1.size());
        Assertions.assertEquals((int)0, (int)iter.previousIndex());
        Assertions.assertEquals((int)1, (int)iter.nextIndex());
        Assertions.assertEquals(this.list1.get(0), iter.previous());
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        Assertions.assertThrows(IllegalStateException.class, () -> iter.remove(), (String)"ListIteratorWrapper does not support the remove() method while dug into the cache via previous()");
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        Assertions.assertEquals(this.list1.get(0), iter.next());
        Assertions.assertEquals((int)0, (int)iter.previousIndex());
        Assertions.assertEquals((int)1, (int)iter.nextIndex());
        Assertions.assertEquals(this.list1.get(1), iter.next());
        Assertions.assertEquals((int)1, (int)iter.previousIndex());
        Assertions.assertEquals((int)2, (int)iter.nextIndex());
        iter.remove();
        Assertions.assertEquals((int)(--sz), (int)this.list1.size());
        Assertions.assertEquals((int)0, (int)iter.previousIndex());
        Assertions.assertEquals((int)1, (int)iter.nextIndex());
        Assertions.assertEquals(this.list1.get(1), iter.next());
        Assertions.assertEquals((int)1, (int)iter.previousIndex());
        Assertions.assertEquals((int)2, (int)iter.nextIndex());
    }

    @Test
    public void testReset() {
        ResettableListIterator<E> iter = this.makeObject();
        Object first = iter.next();
        Object second = iter.next();
        iter.reset();
        Assertions.assertFalse((boolean)iter.hasPrevious(), (String)"No previous elements after reset()");
        Assertions.assertEquals((Object)first, (Object)iter.next(), (String)"First element should be the same");
        Assertions.assertEquals((Object)second, (Object)iter.next(), (String)"Second element should be the same");
        for (int i = 2; i < this.testArray.length; ++i) {
            String testValue = this.testArray[i];
            Object iterValue = iter.next();
            Assertions.assertEquals((Object)testValue, (Object)iterValue, (String)"Iteration value is correct");
        }
    }
}

