/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultKeyValueTest<K, V> {
    private final String key = "name";
    private final String value = "duke";

    protected DefaultKeyValue<K, V> makeDefaultKeyValue() {
        return new DefaultKeyValue(null, null);
    }

    protected DefaultKeyValue<K, V> makeDefaultKeyValue(K key, V value) {
        return new DefaultKeyValue(key, value);
    }

    @Test
    public void testAccessorsAndMutators() {
        DefaultKeyValue<K, V> kv = this.makeDefaultKeyValue();
        kv.setKey((Object)"name");
        Assertions.assertSame((Object)"name", (Object)kv.getKey());
        kv.setValue((Object)"duke");
        Assertions.assertSame((Object)"duke", (Object)kv.getValue());
        kv.setKey(null);
        Assertions.assertNull((Object)kv.getKey());
        kv.setValue(null);
        Assertions.assertNull((Object)kv.getValue());
    }

    @Test
    public void testConstructors() {
        DefaultKeyValue kv = new DefaultKeyValue();
        Assertions.assertTrue((kv.getKey() == null && kv.getValue() == null ? 1 : 0) != 0);
        kv = new DefaultKeyValue((Object)"name", (Object)"duke");
        Assertions.assertTrue((kv.getKey() == "name" && kv.getValue() == "duke" ? 1 : 0) != 0);
        DefaultKeyValue kv2 = new DefaultKeyValue((KeyValue)kv);
        Assertions.assertTrue((kv2.getKey() == "name" && kv2.getValue() == "duke" ? 1 : 0) != 0);
        kv.setKey(null);
        kv.setValue(null);
        Assertions.assertTrue((kv2.getKey() == "name" && kv2.getValue() == "duke" ? 1 : 0) != 0);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "duke");
        Map.Entry entry = map.entrySet().iterator().next();
        kv = new DefaultKeyValue(entry);
        Assertions.assertTrue((kv.getKey() == "name" && kv.getValue() == "duke" ? 1 : 0) != 0);
        entry.setValue(null);
        Assertions.assertSame((Object)"duke", (Object)kv.getValue());
    }

    @Test
    public void testEqualsAndHashCode() {
        DefaultKeyValue<String, String> kv = this.makeDefaultKeyValue("name", "duke");
        DefaultKeyValue<String, String> kv2 = this.makeDefaultKeyValue("name", "duke");
        Assertions.assertEquals(kv, kv);
        Assertions.assertEquals(kv, kv2);
        Assertions.assertEquals((int)kv.hashCode(), (int)kv2.hashCode());
        kv = this.makeDefaultKeyValue(null, null);
        kv2 = this.makeDefaultKeyValue(null, null);
        Assertions.assertEquals(kv, kv);
        Assertions.assertEquals(kv, kv2);
        Assertions.assertEquals((int)kv.hashCode(), (int)kv2.hashCode());
    }

    @Test
    public void testSelfReferenceHandling() {
        DefaultKeyValue kv = this.makeDefaultKeyValue();
        Assertions.assertThrows(IllegalArgumentException.class, () -> kv.setKey((Object)kv));
        Assertions.assertTrue((kv.getKey() == null && kv.getValue() == null ? 1 : 0) != 0);
    }

    @Test
    public void testToMapEntry() {
        DefaultKeyValue<String, String> kv = this.makeDefaultKeyValue("name", "duke");
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(kv.getKey(), kv.getValue());
        Map.Entry entry = map.entrySet().iterator().next();
        Assertions.assertEquals(entry, (Object)kv.toMapEntry());
        Assertions.assertEquals((int)entry.hashCode(), (int)kv.hashCode());
    }

    @Test
    public void testToString() {
        DefaultKeyValue<String, String> kv = this.makeDefaultKeyValue("name", "duke");
        Assertions.assertEquals((Object)kv.toString(), (Object)(kv.getKey() + "=" + kv.getValue()));
        kv = this.makeDefaultKeyValue(null, null);
        Assertions.assertEquals((Object)kv.toString(), (Object)(kv.getKey() + "=" + kv.getValue()));
    }
}

