/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.functors.ConstantFactory;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.DefaultedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultedMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    protected final Factory<V> nullFactory = FactoryUtils.nullFactory();
    protected final Transformer<K, V> nullTransformer = TransformerUtils.nullTransformer();

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public IterableMap<K, V> makeObject() {
        return DefaultedMap.defaultedMap(new HashMap(), this.nullFactory);
    }

    @Test
    public void testFactoryMethods() {
        HashMap base = new HashMap();
        Assertions.assertThrows(NullPointerException.class, () -> DefaultedMap.defaultedMap(null, (Object)"DEFAULT_VALUE"));
        Assertions.assertThrows(NullPointerException.class, () -> DefaultedMap.defaultedMap((Map)null, this.nullFactory));
        Assertions.assertThrows(NullPointerException.class, () -> DefaultedMap.defaultedMap((Map)base, (Factory)null));
        Assertions.assertThrows(NullPointerException.class, () -> DefaultedMap.defaultedMap((Map)null, this.nullTransformer));
        Assertions.assertThrows(NullPointerException.class, () -> DefaultedMap.defaultedMap((Map)base, (Transformer)null));
    }

    @Override
    @Test
    public void testMapGet() {
        DefaultedMap map = new DefaultedMap((Object)"NULL");
        Assertions.assertEquals((int)0, (int)map.size());
        Assertions.assertFalse((boolean)map.containsKey("NotInMap"));
        Assertions.assertEquals((Object)"NULL", map.get("NotInMap"));
        map.put("Key", "Value");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey("Key"));
        Assertions.assertEquals((Object)"Value", map.get("Key"));
        Assertions.assertFalse((boolean)map.containsKey("NotInMap"));
        Assertions.assertEquals((Object)"NULL", map.get("NotInMap"));
    }

    @Test
    public void testMapGet2() {
        HashMap base = new HashMap();
        DefaultedMap map = DefaultedMap.defaultedMap(base, (Object)"NULL");
        Assertions.assertEquals((int)0, (int)map.size());
        Assertions.assertEquals((int)0, (int)base.size());
        Assertions.assertFalse((boolean)map.containsKey("NotInMap"));
        Assertions.assertEquals((Object)"NULL", map.get("NotInMap"));
        map.put("Key", "Value");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((int)1, (int)base.size());
        Assertions.assertTrue((boolean)map.containsKey("Key"));
        Assertions.assertEquals((Object)"Value", map.get("Key"));
        Assertions.assertFalse((boolean)map.containsKey("NotInMap"));
        Assertions.assertEquals((Object)"NULL", map.get("NotInMap"));
    }

    @Test
    public void testMapGet3() {
        HashMap base = new HashMap();
        DefaultedMap map = DefaultedMap.defaultedMap(base, (Factory)ConstantFactory.constantFactory((Object)"NULL"));
        Assertions.assertEquals((int)0, (int)map.size());
        Assertions.assertEquals((int)0, (int)base.size());
        Assertions.assertFalse((boolean)map.containsKey("NotInMap"));
        Assertions.assertEquals((Object)"NULL", map.get("NotInMap"));
        map.put("Key", "Value");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((int)1, (int)base.size());
        Assertions.assertTrue((boolean)map.containsKey("Key"));
        Assertions.assertEquals((Object)"Value", map.get("Key"));
        Assertions.assertFalse((boolean)map.containsKey("NotInMap"));
        Assertions.assertEquals((Object)"NULL", map.get("NotInMap"));
    }

    @Test
    public void testMapGet4() {
        HashMap base = new HashMap();
        Map map = DefaultedMap.defaultedMap(base, input -> {
            if (input instanceof String) {
                return "NULL";
            }
            return "NULL_OBJECT";
        });
        Assertions.assertEquals((int)0, (int)map.size());
        Assertions.assertEquals((int)0, (int)base.size());
        Assertions.assertFalse((boolean)map.containsKey("NotInMap"));
        Assertions.assertEquals((Object)"NULL", map.get("NotInMap"));
        Assertions.assertEquals((Object)"NULL_OBJECT", map.get(0));
        map.put("Key", "Value");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((int)1, (int)base.size());
        Assertions.assertTrue((boolean)map.containsKey("Key"));
        Assertions.assertEquals((Object)"Value", map.get("Key"));
        Assertions.assertFalse((boolean)map.containsKey("NotInMap"));
        Assertions.assertEquals((Object)"NULL", map.get("NotInMap"));
        Assertions.assertEquals((Object)"NULL_OBJECT", map.get(0));
    }
}

