/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.Collection;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMapTest;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.collections4.multimap.TransformedMultiValuedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformedMultiValuedMapTest<K, V>
extends AbstractMultiValuedMapTest<K, V> {
    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public MultiValuedMap<K, V> makeObject() {
        return TransformedMultiValuedMap.transformingMap((MultiValuedMap)new ArrayListValuedHashMap(), (Transformer)TransformerUtils.nopTransformer(), (Transformer)TransformerUtils.nopTransformer());
    }

    @Test
    public void testFactory_Decorate() {
        ArrayListValuedHashMap base = new ArrayListValuedHashMap();
        base.put((Object)"A", (Object)"1");
        base.put((Object)"B", (Object)"2");
        base.put((Object)"C", (Object)"3");
        TransformedMultiValuedMap trans = TransformedMultiValuedMap.transformingMap((MultiValuedMap)base, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)3, (int)trans.size());
        Assertions.assertTrue((boolean)trans.get((Object)"A").contains("1"));
        Assertions.assertTrue((boolean)trans.get((Object)"B").contains("2"));
        Assertions.assertTrue((boolean)trans.get((Object)"C").contains("3"));
        trans.put((Object)"D", (Object)"4");
        Assertions.assertTrue((boolean)trans.get((Object)"D").contains(4));
    }

    @Test
    public void testFactory_decorateTransform() {
        ArrayListValuedHashMap base = new ArrayListValuedHashMap();
        base.put((Object)"A", (Object)"1");
        base.put((Object)"B", (Object)"2");
        base.put((Object)"C", (Object)"3");
        TransformedMultiValuedMap trans = TransformedMultiValuedMap.transformedMap((MultiValuedMap)base, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)3, (int)trans.size());
        Assertions.assertTrue((boolean)trans.get((Object)"A").contains(1));
        Assertions.assertTrue((boolean)trans.get((Object)"B").contains(2));
        Assertions.assertTrue((boolean)trans.get((Object)"C").contains(3));
        trans.put((Object)"D", (Object)"4");
        Assertions.assertTrue((boolean)trans.get((Object)"D").contains(4));
        ArrayListValuedHashMap baseMap = new ArrayListValuedHashMap();
        TransformedMultiValuedMap transMap = TransformedMultiValuedMap.transformedMap((MultiValuedMap)baseMap, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)0, (int)transMap.size());
        transMap.put((Object)"D", (Object)"4");
        Assertions.assertEquals((int)1, (int)transMap.size());
        Assertions.assertTrue((boolean)transMap.get((Object)"D").contains(4));
    }

    @Test
    public void testKeyTransformedMap() {
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        TransformedMultiValuedMap map = TransformedMultiValuedMap.transformingMap((MultiValuedMap)new ArrayListValuedHashMap(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER, null);
        Assertions.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            Assertions.assertEquals((int)(i + 1), (int)map.size());
            Assertions.assertTrue((boolean)map.containsKey((Object)Integer.valueOf((String)els[i])));
            Assertions.assertFalse((boolean)map.containsKey(els[i]));
            Assertions.assertTrue((boolean)map.containsValue(els[i]));
            Assertions.assertTrue((boolean)map.get((Object)Integer.valueOf((String)els[i])).contains(els[i]));
        }
        Collection coll = map.remove(els[0]);
        Assertions.assertNotNull((Object)coll);
        Assertions.assertEquals((int)0, (int)coll.size());
        Assertions.assertTrue((boolean)map.remove((Object)Integer.valueOf((String)els[0])).contains(els[0]));
    }

    @Test
    public void testValueTransformedMap() {
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        TransformedMultiValuedMap map = TransformedMultiValuedMap.transformingMap((MultiValuedMap)new ArrayListValuedHashMap(), null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            Assertions.assertEquals((int)(i + 1), (int)map.size());
            Assertions.assertTrue((boolean)map.containsValue((Object)Integer.valueOf((String)els[i])));
            Assertions.assertFalse((boolean)map.containsValue(els[i]));
            Assertions.assertTrue((boolean)map.containsKey(els[i]));
            Assertions.assertTrue((boolean)map.get(els[i]).contains(Integer.valueOf((String)els[i])));
        }
        Assertions.assertTrue((boolean)map.remove(els[0]).contains(Integer.valueOf((String)els[0])));
    }
}

