/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import org.apache.commons.statistics.descriptive.LongMean;
import org.apache.commons.statistics.distribution.ChiSquaredDistribution;
import org.apache.commons.statistics.inference.Arguments;
import org.apache.commons.statistics.inference.BaseSignificanceResult;
import org.apache.commons.statistics.inference.InferenceException;
import org.apache.commons.statistics.inference.SignificanceResult;
import org.apache.commons.statistics.inference.StatisticUtils;

public final class ChiSquareTest {
    private static final String ROW = "row";
    private static final String COLUMN = "column";
    private static final ChiSquareTest DEFAULT = new ChiSquareTest(0);
    private final int degreesOfFreedomAdjustment;

    private ChiSquareTest(int degreesOfFreedomAdjustment) {
        this.degreesOfFreedomAdjustment = degreesOfFreedomAdjustment;
    }

    public static ChiSquareTest withDefaults() {
        return DEFAULT;
    }

    public ChiSquareTest withDegreesOfFreedomAdjustment(int v) {
        return new ChiSquareTest(Arguments.checkNonNegative(v));
    }

    public double statistic(long[] observed) {
        Arguments.checkValuesRequiredSize(observed.length, 2);
        Arguments.checkNonNegative(observed);
        double e = LongMean.of((long[])observed).getAsDouble();
        if (e == 0.0) {
            throw new InferenceException("No data");
        }
        double chi2 = 0.0;
        for (long o : observed) {
            double d = (double)o - e;
            chi2 += d * d;
        }
        return chi2 / e;
    }

    public double statistic(double[] expected, long[] observed) {
        double ratio = StatisticUtils.computeRatio(expected, observed);
        double chi2 = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            double e = ratio * expected[i];
            double d = (double)observed[i] - e;
            chi2 += d * d / e;
        }
        return chi2;
    }

    public double statistic(long[][] counts) {
        Arguments.checkCategoriesRequiredSize(counts.length, 2);
        Arguments.checkValuesRequiredSize(counts[0].length, 2);
        Arguments.checkRectangular(counts);
        Arguments.checkNonNegative(counts);
        int nRows = counts.length;
        int nCols = counts[0].length;
        double[] rowSum = new double[nRows];
        double[] colSum = new double[nCols];
        double sum = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                int n = row;
                rowSum[n] = rowSum[n] + (double)counts[row][col];
                int n2 = col;
                colSum[n2] = colSum[n2] + (double)counts[row][col];
            }
            ChiSquareTest.checkNonZero(rowSum[row], ROW, row);
            sum += rowSum[row];
        }
        for (int col = 0; col < nCols; ++col) {
            ChiSquareTest.checkNonZero(colSum[col], COLUMN, col);
        }
        double chi2 = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                double e = rowSum[row] * colSum[col] / sum;
                double d = (double)counts[row][col] - e;
                chi2 += d * d / e;
            }
        }
        return chi2;
    }

    public double statistic(long[] observed1, long[] observed2) {
        Arguments.checkValuesRequiredSize(observed1.length, 2);
        Arguments.checkValuesSizeMatch(observed1.length, observed2.length);
        Arguments.checkNonNegative(observed1);
        Arguments.checkNonNegative(observed2);
        long colSum1 = 0L;
        long colSum2 = 0L;
        for (int i = 0; i < observed1.length; ++i) {
            long obs1 = observed1[i];
            long obs2 = observed2[i];
            ChiSquareTest.checkNonZero(obs1 | obs2, ROW, i);
            colSum1 += obs1;
            colSum2 += obs2;
        }
        ChiSquareTest.checkNonZero(colSum1, COLUMN, 0);
        ChiSquareTest.checkNonZero(colSum2, COLUMN, 1);
        boolean unequalCounts = colSum1 != colSum2;
        double weight = unequalCounts ? Math.sqrt((double)colSum1 / (double)colSum2) : 1.0;
        double chi2 = 0.0;
        for (int i = 0; i < observed1.length; ++i) {
            double obs1 = observed1[i];
            double obs2 = observed2[i];
            double d = unequalCounts ? obs1 / weight - obs2 * weight : obs1 - obs2;
            chi2 += d * d / (obs1 + obs2);
        }
        return chi2;
    }

    public SignificanceResult test(long[] observed) {
        int df = observed.length - 1;
        double chi2 = this.statistic(observed);
        double p = ChiSquareTest.computeP(chi2, df);
        return new BaseSignificanceResult(chi2, p);
    }

    public SignificanceResult test(double[] expected, long[] observed) {
        int df = StatisticUtils.computeDegreesOfFreedom(observed.length, this.degreesOfFreedomAdjustment);
        double chi2 = this.statistic(expected, observed);
        double p = ChiSquareTest.computeP(chi2, df);
        return new BaseSignificanceResult(chi2, p);
    }

    public SignificanceResult test(long[][] counts) {
        double chi2 = this.statistic(counts);
        double df = ((double)counts.length - 1.0) * ((double)counts[0].length - 1.0);
        double p = ChiSquareTest.computeP(chi2, df);
        return new BaseSignificanceResult(chi2, p);
    }

    public SignificanceResult test(long[] observed1, long[] observed2) {
        double chi2 = this.statistic(observed1, observed2);
        double p = ChiSquareTest.computeP(chi2, (double)observed1.length - 1.0);
        return new BaseSignificanceResult(chi2, p);
    }

    private static double computeP(double chi2, double degreesOfFreedom) {
        return ChiSquaredDistribution.of((double)degreesOfFreedom).survivalProbability(chi2);
    }

    private static void checkNonZero(double value, String name, int index) {
        if (value == 0.0) {
            throw new InferenceException("%s[%s] is zero", name, index);
        }
    }
}

