/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.LockModeType;
import java.util.Collections;
import java.util.Map;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.JPACodeDataProvider;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;

public class JPACMTCodeDataProvider
extends JPACodeDataProvider {
    private static final int DEFAULT_PESSIMISTIC_LOCK_TIMEOUT = 10000;
    private int pessimisticLockTimeout = 10000;
    private boolean useJpaLockForExistingRefreshToken = true;
    private EntityManager entityManager;

    @Override
    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    protected EntityTransaction beginIfNeeded(EntityManager em) {
        return null;
    }

    @Override
    protected void commitIfNeeded(EntityManager em) {
    }

    @Override
    protected void closeIfNeeded(EntityManager em) {
    }

    @Override
    protected RefreshToken updateExistingRefreshToken(RefreshToken rt, ServerAccessToken at) {
        if (this.useJpaLockForExistingRefreshToken) {
            this.lockRefreshTokenForUpdate(rt);
            return super.updateRefreshToken(rt, at);
        }
        return super.updateExistingRefreshToken(rt, at);
    }

    protected void lockRefreshTokenForUpdate(RefreshToken refreshToken) {
        try {
            this.execute(em -> {
                Map<Object, Object> options = this.pessimisticLockTimeout > 0 ? Collections.singletonMap("jakarta.persistence.lock.timeout", this.pessimisticLockTimeout) : Collections.emptyMap();
                em.refresh((Object)refreshToken, LockModeType.PESSIMISTIC_WRITE, options);
                return null;
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setPessimisticLockTimeout(int pessimisticLockTimeout) {
        this.pessimisticLockTimeout = pessimisticLockTimeout;
    }

    public void setUseJpaLockForExistingRefreshToken(boolean useJpaLockForExistingRefreshToken) {
        this.useJpaLockForExistingRefreshToken = useJpaLockForExistingRefreshToken;
    }
}

