/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import org.apache.daffodil.io.processors.charset.BitsCharset;
import org.apache.daffodil.io.processors.charset.BitsCharsetDefinitionRegistry$;
import org.apache.daffodil.io.processors.charset.CharsetUtils$;
import org.apache.daffodil.runtime1.dsom.DPathCompileInfo;
import org.apache.daffodil.runtime1.processors.EncodingEvBase;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.Evaluatable$;
import org.apache.daffodil.runtime1.processors.InfosetCachedEvaluatable;
import org.apache.daffodil.runtime1.processors.ParseOrUnparseState;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public abstract class CharsetEvBase
extends Evaluatable<BitsCharset>
implements InfosetCachedEvaluatable<BitsCharset> {
    private final EncodingEvBase encodingEv;
    private final DPathCompileInfo tci;

    public CharsetEvBase(EncodingEvBase encodingEv, DPathCompileInfo tci) {
        this.encodingEv = encodingEv;
        this.tci = tci;
        super(tci, Evaluatable$.MODULE$.$lessinit$greater$default$2());
    }

    @Override
    public Seq<Evaluatable<Object>> runtimeDependencies() {
        return (Seq)((SeqOps)new .colon.colon((Object)this.encodingEv, (List)Nil$.MODULE$));
    }

    private void checkCharset(ParseOrUnparseState state, BitsCharset bitsCharset) {
        if (bitsCharset.bitWidthOfACodeUnit() != 8) {
            throw this.tci.schemaDefinitionError("Only encodings with byte-sized code units are allowed to be specified using a runtime-valued expression. Encodings with 7 or fewer bits in their code units must be specified as a literal encoding name in the DFDL schema. The encoding found was '%s'.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bitsCharset.name()}));
        }
    }

    @Override
    public BitsCharset compute(ParseOrUnparseState state) {
        String encString = (String)this.encodingEv.evaluate(state);
        BitsCharset bc = CharsetUtils$.MODULE$.getCharset(encString);
        if (bc == null) {
            throw this.tci.schemaDefinitionError("Unsupported encoding: %s. Supported encodings: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{encString, BitsCharsetDefinitionRegistry$.MODULE$.supportedEncodingsString()}));
        }
        if (!this.encodingEv.isConstant()) {
            this.checkCharset(state, bc);
        }
        return bc;
    }
}

