/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.server.audit.AuditManagerConfig;
import org.apache.druid.server.audit.AuditSerdeHelper;
import org.apache.druid.server.audit.SQLAuditManagerConfig;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

@ManageLifecycle
public class SQLAuditManager
implements AuditManager {
    private final IDBI dbi;
    private final SQLMetadataConnector connector;
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final ServiceEmitter emitter;
    private final ObjectMapper jsonMapper;
    private final SQLAuditManagerConfig config;
    private final AuditSerdeHelper serdeHelper;
    private final ResultSetMapper<AuditEntry> resultMapper;

    @Inject
    public SQLAuditManager(AuditManagerConfig config, AuditSerdeHelper serdeHelper, SQLMetadataConnector connector, Supplier<MetadataStorageTablesConfig> dbTables, ServiceEmitter emitter, @Json ObjectMapper jsonMapper) {
        this.dbi = connector.getDBI();
        this.connector = connector;
        this.dbTables = dbTables;
        this.emitter = emitter;
        this.jsonMapper = jsonMapper;
        this.serdeHelper = serdeHelper;
        this.resultMapper = new AuditEntryMapper();
        if (!(config instanceof SQLAuditManagerConfig)) {
            throw DruidException.defensive((String)"Config[%s] is not an instance of SQLAuditManagerConfig", (Object[])new Object[]{config});
        }
        this.config = (SQLAuditManagerConfig)config;
    }

    @LifecycleStart
    public void start() {
        this.connector.createAuditTable();
    }

    @LifecycleStop
    public void stop() {
    }

    private String getAuditTable() {
        return ((MetadataStorageTablesConfig)this.dbTables.get()).getAuditTable();
    }

    public void doAudit(AuditEntry event) {
        this.dbi.withHandle(handle -> {
            this.doAudit(event, handle);
            return 0;
        });
    }

    private ServiceMetricEvent.Builder createMetricEventBuilder(AuditEntry entry) {
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("key", (Object)entry.getKey()).setDimension("type", (Object)entry.getType()).setDimension("author", (Object)entry.getAuditInfo().getAuthor()).setDimension("comment", (Object)entry.getAuditInfo().getComment()).setDimension("remote_address", (Object)entry.getAuditInfo().getIp()).setDimension("created_date", (Object)entry.getAuditTime().toString());
        if (this.config.isIncludePayloadAsDimensionInMetric()) {
            builder.setDimension("payload", (Object)entry.getPayload().serialized());
        }
        return builder;
    }

    public void doAudit(AuditEntry event, Handle handle) throws IOException {
        if (!this.serdeHelper.shouldProcessAuditEntry(event)) {
            return;
        }
        this.emitter.emit((ServiceEventBuilder)this.createMetricEventBuilder(event).setMetric("config/audit", (Number)1));
        AuditEntry record = this.serdeHelper.processAuditEntry(event);
        ((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %s (audit_key, type, author, comment, created_date, payload) VALUES (:audit_key, :type, :author, :comment, :created_date, :payload)", (Object[])new Object[]{this.getAuditTable()})).bind("audit_key", record.getKey())).bind("type", record.getType())).bind("author", record.getAuditInfo().getAuthor())).bind("comment", record.getAuditInfo().getComment())).bind("created_date", record.getAuditTime().toString())).bind("payload", this.jsonMapper.writeValueAsBytes((Object)record))).execute();
    }

    public List<AuditEntry> fetchAuditHistory(String key, String type, Interval interval) {
        Interval theInterval = this.createAuditHistoryIntervalIfNull(interval);
        return (List)this.dbi.withHandle(handle -> ((Query)((Query)((Query)((Query)handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE audit_key = :audit_key and type = :type and created_date between :start_date and :end_date ORDER BY created_date", (Object[])new Object[]{this.getAuditTable()})).bind("audit_key", key)).bind("type", type)).bind("start_date", theInterval.getStart().toString())).bind("end_date", theInterval.getEnd().toString())).map(this.resultMapper).list());
    }

    private Interval createAuditHistoryIntervalIfNull(Interval interval) {
        if (interval == null) {
            DateTime now = DateTimes.nowUtc();
            return new Interval((ReadableInstant)now.minus(this.config.getAuditHistoryMillis()), (ReadableInstant)now);
        }
        return interval;
    }

    private int getLimit(int limit) throws IllegalArgumentException {
        if (limit < 1) {
            throw new IllegalArgumentException("Limit must be greater than zero!");
        }
        return limit;
    }

    public List<AuditEntry> fetchAuditHistory(String type, Interval interval) {
        Interval theInterval = this.createAuditHistoryIntervalIfNull(interval);
        return (List)this.dbi.withHandle(handle -> ((Query)((Query)((Query)handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE type = :type and created_date between :start_date and :end_date ORDER BY created_date", (Object[])new Object[]{this.getAuditTable()})).bind("type", type)).bind("start_date", theInterval.getStart().toString())).bind("end_date", theInterval.getEnd().toString())).map(this.resultMapper).list());
    }

    public List<AuditEntry> fetchAuditHistory(String key, String type, int limit) throws IllegalArgumentException {
        return this.fetchAuditHistoryLastEntries(key, type, limit);
    }

    public List<AuditEntry> fetchAuditHistory(String type, int limit) throws IllegalArgumentException {
        return this.fetchAuditHistoryLastEntries(null, type, limit);
    }

    public int removeAuditLogsOlderThan(long timestamp) {
        DateTime dateTime = DateTimes.utc((long)timestamp);
        return (Integer)this.dbi.withHandle(handle -> {
            Update sql = handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE created_date < :date_time", (Object[])new Object[]{this.getAuditTable()}));
            return ((Update)sql.bind("date_time", dateTime.toString())).execute();
        });
    }

    private List<AuditEntry> fetchAuditHistoryLastEntries(String key, String type, int limit) throws IllegalArgumentException {
        int theLimit = this.getLimit(limit);
        String queryString = StringUtils.format((String)"SELECT payload FROM %s WHERE type = :type", (Object[])new Object[]{this.getAuditTable()});
        if (key != null) {
            queryString = queryString + " and audit_key = :audit_key";
        }
        String theQueryString = queryString = queryString + " ORDER BY created_date DESC";
        return (List)this.dbi.withHandle(handle -> {
            Query query = handle.createQuery(theQueryString);
            if (key != null) {
                query.bind("audit_key", key);
            }
            return ((Query)query.bind("type", type)).setMaxRows(theLimit).map(this.resultMapper).list();
        });
    }

    private class AuditEntryMapper
    implements ResultSetMapper<AuditEntry> {
        private AuditEntryMapper() {
        }

        public AuditEntry map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return (AuditEntry)JacksonUtils.readValue((ObjectMapper)SQLAuditManager.this.jsonMapper, (byte[])r.getBytes("payload"), AuditEntry.class);
        }
    }
}

