/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.server.coordination.ChangeRequestsSnapshot;
import org.apache.druid.utils.CircularBuffer;

public class ChangeRequestHistory<T> {
    private static int MAX_SIZE = 1000;
    private final int maxSize;
    private final CircularBuffer<Holder<T>> changes;
    @VisibleForTesting
    final LinkedHashMap<CustomSettableFuture<T>, Counter> waitingFutures;
    private final ExecutorService singleThreadedExecutor;
    private final Runnable resolveWaitingFuturesRunnable;

    public ChangeRequestHistory() {
        this(MAX_SIZE);
    }

    public ChangeRequestHistory(int maxSize) {
        this.maxSize = maxSize;
        this.changes = new CircularBuffer(maxSize);
        this.waitingFutures = new LinkedHashMap();
        this.resolveWaitingFuturesRunnable = this::resolveWaitingFutures;
        this.singleThreadedExecutor = Execs.singleThreaded((String)"SegmentChangeRequestHistory");
    }

    public void stop() {
        this.singleThreadedExecutor.shutdownNow();
        LinkedHashSet<CustomSettableFuture<T>> futures = new LinkedHashSet<CustomSettableFuture<T>>(this.waitingFutures.keySet());
        this.waitingFutures.clear();
        for (CustomSettableFuture customSettableFuture : futures) {
            customSettableFuture.setException(new IllegalStateException("Server is shutting down."));
        }
    }

    public synchronized void addChangeRequests(List<T> requests) {
        if (this.singleThreadedExecutor.isShutdown()) {
            return;
        }
        if (requests.isEmpty()) {
            return;
        }
        for (T request : requests) {
            this.changes.add(new Holder<T>(request, this.getLastCounter().inc()));
        }
        this.singleThreadedExecutor.execute(this.resolveWaitingFuturesRunnable);
    }

    public synchronized void addChangeRequest(T request) {
        this.addChangeRequests((List<T>)ImmutableList.of(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ListenableFuture<ChangeRequestsSnapshot<T>> getRequestsSince(Counter counter) {
        CustomSettableFuture<T> future = new CustomSettableFuture<T>(this.waitingFutures);
        if (this.singleThreadedExecutor.isShutdown()) {
            future.setException(new IllegalStateException("Server is shutting down."));
            return future;
        }
        if (counter.counter < 0L) {
            future.setException((Throwable)new IAE("counter[%s] must be >= 0", new Object[]{counter}));
            return future;
        }
        Counter lastCounter = this.getLastCounter();
        if (counter.counter == lastCounter.counter) {
            if (!counter.matches(lastCounter)) {
                ChangeRequestsSnapshot reset = ChangeRequestsSnapshot.fail(StringUtils.format((String)"counter[%s] failed to match with [%s]", (Object[])new Object[]{counter, lastCounter}));
                future.set(reset);
            } else {
                LinkedHashMap<CustomSettableFuture<T>, Counter> reset = this.waitingFutures;
                synchronized (reset) {
                    this.waitingFutures.put(future, counter);
                }
            }
        } else {
            try {
                future.set(this.getRequestsSinceWithoutWait(counter));
            }
            catch (Exception ex) {
                future.setException(ex);
            }
        }
        return future;
    }

    private synchronized ChangeRequestsSnapshot<T> getRequestsSinceWithoutWait(Counter counter) {
        Counter counterToMatch;
        Counter lastCounter = this.getLastCounter();
        if (counter.counter == lastCounter.counter) {
            if (counter.matches(lastCounter)) {
                return ChangeRequestsSnapshot.success(counter, new ArrayList());
            }
            return ChangeRequestsSnapshot.fail(StringUtils.format((String)"counter[%s] failed to match with [%s]", (Object[])new Object[]{counter, lastCounter}));
        }
        if (counter.counter > lastCounter.counter) {
            return ChangeRequestsSnapshot.fail(StringUtils.format((String)"counter[%s] > last counter[%s]", (Object[])new Object[]{counter, lastCounter}));
        }
        if (lastCounter.counter - counter.counter >= (long)this.maxSize) {
            return ChangeRequestsSnapshot.fail(StringUtils.format((String)"can't serve request, not enough history is kept. given counter [%s] and current last counter [%s]", (Object[])new Object[]{counter, lastCounter}));
        }
        int changeStartIndex = (int)(counter.counter + (long)this.changes.size() - lastCounter.counter);
        Counter counter2 = counterToMatch = counter.counter == 0L ? Counter.ZERO : ((Holder)this.changes.get(changeStartIndex - 1)).counter;
        if (!counterToMatch.matches(counter)) {
            return ChangeRequestsSnapshot.fail(StringUtils.format((String)"counter[%s] failed to match with [%s]", (Object[])new Object[]{counter, lastCounter}));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = changeStartIndex; i < this.changes.size(); ++i) {
            result.add(((Holder)this.changes.get(i)).changeRequest);
        }
        return ChangeRequestsSnapshot.success(((Holder)this.changes.get(this.changes.size() - 1)).counter, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveWaitingFutures() {
        LinkedHashMap<CustomSettableFuture<T>, Counter> waitingFuturesCopy;
        LinkedHashMap<CustomSettableFuture<T>, Counter> linkedHashMap = this.waitingFutures;
        synchronized (linkedHashMap) {
            waitingFuturesCopy = new LinkedHashMap<CustomSettableFuture<T>, Counter>(this.waitingFutures);
            this.waitingFutures.clear();
        }
        for (Map.Entry entry : waitingFuturesCopy.entrySet()) {
            try {
                ((CustomSettableFuture)((Object)entry.getKey())).set(this.getRequestsSinceWithoutWait((Counter)entry.getValue()));
            }
            catch (Exception ex) {
                ((CustomSettableFuture)((Object)entry.getKey())).setException(ex);
            }
        }
    }

    public synchronized Counter getLastCounter() {
        if (this.changes.size() > 0) {
            return ((Holder)this.changes.get(this.changes.size() - 1)).counter;
        }
        return Counter.ZERO;
    }

    private static class CustomSettableFuture<T>
    extends AbstractFuture<ChangeRequestsSnapshot<T>> {
        private final LinkedHashMap<CustomSettableFuture<T>, Counter> waitingFutures;

        private CustomSettableFuture(LinkedHashMap<CustomSettableFuture<T>, Counter> waitingFutures) {
            this.waitingFutures = waitingFutures;
        }

        public boolean set(ChangeRequestsSnapshot<T> value) {
            return super.set(value);
        }

        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(boolean interruptIfRunning) {
            LinkedHashMap<CustomSettableFuture<T>, Counter> linkedHashMap = this.waitingFutures;
            synchronized (linkedHashMap) {
                this.waitingFutures.remove((Object)this);
            }
            return true;
        }
    }

    public static class Counter {
        public static final Counter ZERO = new Counter(0L);
        private final long counter;
        private final long hash;

        public Counter(long counter) {
            this(counter, System.currentTimeMillis());
        }

        @JsonCreator
        public Counter(@JsonProperty(value="counter") long counter, @JsonProperty(value="hash") long hash) {
            this.counter = counter;
            this.hash = hash;
        }

        @JsonProperty
        public long getCounter() {
            return this.counter;
        }

        @JsonProperty
        public long getHash() {
            return this.hash;
        }

        public Counter inc() {
            return new Counter(this.counter + 1L);
        }

        public boolean matches(Counter other) {
            return this.counter == other.counter && this.hash == other.hash;
        }

        public String toString() {
            return "Counter{counter=" + this.counter + ", hash=" + this.hash + '}';
        }
    }

    private static class Holder<T> {
        private final T changeRequest;
        private final Counter counter;

        public Holder(T changeRequest, Counter counter) {
            this.changeRequest = changeRequest;
            this.counter = counter;
        }
    }
}

