/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.druid.server.coordination.DataSegmentChangeHandler;
import org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.druid.server.coordination.DataSegmentChangeResponse;
import org.apache.druid.server.coordination.SegmentChangeRequestDrop;
import org.apache.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.druid.server.coordination.SegmentChangeStatus;
import org.apache.druid.server.metrics.SegmentRowCountDistribution;
import org.apache.druid.timeline.DataSegment;

@ManageLifecycle
public class SegmentLoadDropHandler
implements DataSegmentChangeHandler {
    private static final EmittingLogger log = new EmittingLogger(SegmentLoadDropHandler.class);
    private final Object segmentDeleteLock = new Object();
    private final SegmentLoaderConfig config;
    private final DataSegmentAnnouncer announcer;
    private final SegmentManager segmentManager;
    private final ScheduledExecutorService exec;
    private final ConcurrentSkipListSet<DataSegment> segmentsToDelete;
    private final Cache<DataSegmentChangeRequest, AtomicReference<SegmentChangeStatus>> requestStatuses;
    private final Object requestStatusesLock = new Object();
    private final LinkedHashSet<CustomSettableFuture> waitingFutures = new LinkedHashSet();

    @Inject
    public SegmentLoadDropHandler(SegmentLoaderConfig config, DataSegmentAnnouncer announcer, SegmentManager segmentManager) {
        this(config, announcer, segmentManager, Executors.newScheduledThreadPool(config.getNumLoadingThreads(), Execs.makeThreadFactory((String)"SimpleDataSegmentChangeHandler-%s")));
    }

    @VisibleForTesting
    SegmentLoadDropHandler(SegmentLoaderConfig config, DataSegmentAnnouncer announcer, SegmentManager segmentManager, ScheduledExecutorService exec) {
        this.config = config;
        this.announcer = announcer;
        this.segmentManager = segmentManager;
        this.exec = exec;
        this.segmentsToDelete = new ConcurrentSkipListSet();
        this.requestStatuses = CacheBuilder.newBuilder().maximumSize((long)config.getStatusQueueMaxSize()).initialCapacity(8).build();
    }

    public Map<String, Long> getAverageNumOfRowsPerSegmentForDatasource() {
        return this.segmentManager.getAverageRowCountForDatasource();
    }

    public Map<String, SegmentRowCountDistribution> getRowCountDistributionPerDatasource() {
        return this.segmentManager.getRowCountDistribution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSegment(DataSegment segment, @Nullable DataSegmentChangeCallback callback) {
        SegmentChangeStatus result = null;
        try {
            log.info("Loading segment[%s]", new Object[]{segment.getId()});
            if (this.segmentsToDelete.contains(segment)) {
                Object object = this.segmentDeleteLock;
                synchronized (object) {
                    this.segmentsToDelete.remove(segment);
                }
            }
            try {
                this.segmentManager.loadSegment(segment);
            }
            catch (Exception e) {
                this.removeSegment(segment, DataSegmentChangeCallback.NOOP, false);
                throw new SegmentLoadingException((Throwable)e, "Exception loading segment[%s]", new Object[]{segment.getId()});
            }
            try {
                this.announcer.announceSegment(segment);
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Failed to announce segment[%s]", new Object[]{segment.getId()});
            }
            result = SegmentChangeStatus.SUCCESS;
            this.updateRequestStatus(new SegmentChangeRequestLoad(segment), result);
            if (null != callback) {
                callback.execute();
            }
        }
        catch (Throwable e) {
            try {
                log.makeAlert(e, "Failed to load segment", new Object[0]).addData("segment", (Object)segment).emit();
                result = SegmentChangeStatus.failed(e.toString());
                this.updateRequestStatus(new SegmentChangeRequestLoad(segment), result);
                if (null != callback) {
                    callback.execute();
                }
            }
            catch (Throwable throwable) {
                this.updateRequestStatus(new SegmentChangeRequestLoad(segment), result);
                if (null != callback) {
                    callback.execute();
                }
                throw throwable;
            }
        }
    }

    @Override
    public void removeSegment(DataSegment segment, @Nullable DataSegmentChangeCallback callback) {
        this.removeSegment(segment, callback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void removeSegment(DataSegment segment, @Nullable DataSegmentChangeCallback callback, boolean scheduleDrop) {
        SegmentChangeStatus result = null;
        try {
            this.announcer.unannounceSegment(segment);
            this.segmentsToDelete.add(segment);
            Runnable runnable = () -> {
                try {
                    Object object = this.segmentDeleteLock;
                    synchronized (object) {
                        if (this.segmentsToDelete.remove(segment)) {
                            this.segmentManager.dropSegment(segment);
                        }
                    }
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to remove segment! Possible resource leak!", new Object[0]).addData("segment", (Object)segment).emit();
                }
            };
            if (scheduleDrop) {
                log.info("Completely removing segment[%s] in [%,d]ms.", new Object[]{segment.getId(), this.config.getDropSegmentDelayMillis()});
                this.exec.schedule(runnable, (long)this.config.getDropSegmentDelayMillis(), TimeUnit.MILLISECONDS);
            } else {
                runnable.run();
            }
            result = SegmentChangeStatus.SUCCESS;
            this.updateRequestStatus(new SegmentChangeRequestDrop(segment), result);
            if (null != callback) {
                callback.execute();
            }
        }
        catch (Exception e) {
            try {
                log.makeAlert((Throwable)e, "Failed to remove segment", new Object[0]).addData("segment", (Object)segment).emit();
                result = SegmentChangeStatus.failed(e.getMessage());
                this.updateRequestStatus(new SegmentChangeRequestDrop(segment), result);
                if (null != callback) {
                    callback.execute();
                }
            }
            catch (Throwable throwable) {
                this.updateRequestStatus(new SegmentChangeRequestDrop(segment), result);
                if (null != callback) {
                    callback.execute();
                }
                throw throwable;
            }
        }
    }

    public Collection<DataSegment> getSegmentsToDelete() {
        return ImmutableList.copyOf(this.segmentsToDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<List<DataSegmentChangeResponse>> processBatch(List<DataSegmentChangeRequest> changeRequests) {
        boolean isAnyRequestDone = false;
        HashMap statuses = Maps.newHashMapWithExpectedSize((int)changeRequests.size());
        for (DataSegmentChangeRequest cr : changeRequests) {
            AtomicReference<SegmentChangeStatus> status = this.processRequest(cr);
            if (status.get().getState() != SegmentChangeStatus.State.PENDING) {
                isAnyRequestDone = true;
            }
            statuses.put(cr, status);
        }
        CustomSettableFuture future = new CustomSettableFuture(this.waitingFutures, statuses);
        if (isAnyRequestDone) {
            future.resolve();
        } else {
            LinkedHashSet<CustomSettableFuture> linkedHashSet = this.waitingFutures;
            synchronized (linkedHashSet) {
                this.waitingFutures.add(future);
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicReference<SegmentChangeStatus> processRequest(final DataSegmentChangeRequest changeRequest) {
        Object object = this.requestStatusesLock;
        synchronized (object) {
            AtomicReference status = (AtomicReference)this.requestStatuses.getIfPresent((Object)changeRequest);
            if (status == null || ((SegmentChangeStatus)status.get()).getState() == SegmentChangeStatus.State.FAILED) {
                changeRequest.go(new DataSegmentChangeHandler(){

                    @Override
                    public void addSegment(DataSegment segment, @Nullable DataSegmentChangeCallback callback) {
                        SegmentLoadDropHandler.this.requestStatuses.put((Object)changeRequest, new AtomicReference<SegmentChangeStatus>(SegmentChangeStatus.PENDING));
                        SegmentLoadDropHandler.this.exec.submit(() -> SegmentLoadDropHandler.this.addSegment(((SegmentChangeRequestLoad)changeRequest).getSegment(), () -> SegmentLoadDropHandler.this.resolveWaitingFutures()));
                    }

                    @Override
                    public void removeSegment(DataSegment segment, @Nullable DataSegmentChangeCallback callback) {
                        SegmentLoadDropHandler.this.requestStatuses.put((Object)changeRequest, new AtomicReference<SegmentChangeStatus>(SegmentChangeStatus.PENDING));
                        SegmentLoadDropHandler.this.removeSegment(((SegmentChangeRequestDrop)changeRequest).getSegment(), () -> SegmentLoadDropHandler.this.resolveWaitingFutures(), true);
                    }
                }, this::resolveWaitingFutures);
            } else if (((SegmentChangeStatus)status.get()).getState() == SegmentChangeStatus.State.SUCCESS) {
                this.requestStatuses.invalidate((Object)changeRequest);
                return status;
            }
            return (AtomicReference)this.requestStatuses.getIfPresent((Object)changeRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRequestStatus(DataSegmentChangeRequest changeRequest, @Nullable SegmentChangeStatus result) {
        if (result == null) {
            result = SegmentChangeStatus.failed("Unknown reason. Check server logs.");
        }
        Object object = this.requestStatusesLock;
        synchronized (object) {
            AtomicReference statusRef = (AtomicReference)this.requestStatuses.getIfPresent((Object)changeRequest);
            if (statusRef != null) {
                statusRef.set(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveWaitingFutures() {
        LinkedHashSet<CustomSettableFuture> waitingFuturesCopy;
        LinkedHashSet<CustomSettableFuture> linkedHashSet = this.waitingFutures;
        synchronized (linkedHashSet) {
            waitingFuturesCopy = new LinkedHashSet<CustomSettableFuture>(this.waitingFutures);
            this.waitingFutures.clear();
        }
        for (CustomSettableFuture future : waitingFuturesCopy) {
            future.resolve();
        }
    }

    private class CustomSettableFuture
    extends AbstractFuture<List<DataSegmentChangeResponse>> {
        private final LinkedHashSet<CustomSettableFuture> waitingFutures;
        private final Map<DataSegmentChangeRequest, AtomicReference<SegmentChangeStatus>> statusRefs;

        private CustomSettableFuture(LinkedHashSet<CustomSettableFuture> waitingFutures, Map<DataSegmentChangeRequest, AtomicReference<SegmentChangeStatus>> statusRefs) {
            this.waitingFutures = waitingFutures;
            this.statusRefs = statusRefs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resolve() {
            Object object = SegmentLoadDropHandler.this.requestStatusesLock;
            synchronized (object) {
                if (this.isDone()) {
                    return;
                }
                ArrayList result = new ArrayList(this.statusRefs.size());
                this.statusRefs.forEach((request, statusRef) -> {
                    SegmentChangeStatus status = (SegmentChangeStatus)statusRef.get();
                    if (status != null && status.getState() != SegmentChangeStatus.State.PENDING) {
                        SegmentLoadDropHandler.this.requestStatuses.invalidate(request);
                    }
                    result.add(new DataSegmentChangeResponse((DataSegmentChangeRequest)request, status));
                });
                this.set(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(boolean interruptIfRunning) {
            LinkedHashSet<CustomSettableFuture> linkedHashSet = this.waitingFutures;
            synchronized (linkedHashSet) {
                this.waitingFutures.remove((Object)this);
            }
            return true;
        }
    }
}

