/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.factories;

import com.github.rvesse.airline.annotations.restrictions.MutuallyExclusiveWith;
import com.github.rvesse.airline.annotations.restrictions.RequireOnlyOne;
import com.github.rvesse.airline.annotations.restrictions.RequireSome;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.factories.OptionRestrictionFactory;
import com.github.rvesse.airline.restrictions.options.MutuallyExclusiveRestriction;
import com.github.rvesse.airline.restrictions.options.RequireFromRestriction;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class RequireFromRestrictionFactory
implements OptionRestrictionFactory {
    @Override
    public OptionRestriction createOptionRestriction(Annotation annotation) {
        if (annotation instanceof RequireSome) {
            RequireSome some = (RequireSome)annotation;
            return new RequireFromRestriction(some.tag(), false);
        }
        if (annotation instanceof RequireOnlyOne) {
            RequireOnlyOne one = (RequireOnlyOne)annotation;
            return new RequireFromRestriction(one.tag(), true);
        }
        if (annotation instanceof MutuallyExclusiveWith) {
            MutuallyExclusiveWith mutExcl = (MutuallyExclusiveWith)annotation;
            return new MutuallyExclusiveRestriction(mutExcl.tag());
        }
        return null;
    }

    @Override
    public List<Class<? extends Annotation>> supportedOptionAnnotations() {
        ArrayList<Class<? extends Annotation>> supported = new ArrayList<Class<? extends Annotation>>();
        supported.add(RequireSome.class);
        supported.add(RequireOnlyOne.class);
        supported.add(MutuallyExclusiveWith.class);
        return supported;
    }
}

