/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ReplicationControllerCondition;
import io.kubernetes.client.openapi.models.V1ReplicationControllerConditionBuilder;
import io.kubernetes.client.openapi.models.V1ReplicationControllerConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1ReplicationControllerStatus;
import io.kubernetes.client.openapi.models.V1ReplicationControllerStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ReplicationControllerStatusFluentImpl<A extends V1ReplicationControllerStatusFluent<A>>
extends BaseFluent<A>
implements V1ReplicationControllerStatusFluent<A> {
    private Integer availableReplicas;
    private ArrayList<V1ReplicationControllerConditionBuilder> conditions;
    private Integer fullyLabeledReplicas;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;

    public V1ReplicationControllerStatusFluentImpl() {
    }

    public V1ReplicationControllerStatusFluentImpl(V1ReplicationControllerStatus instance) {
        if (instance != null) {
            this.withAvailableReplicas(instance.getAvailableReplicas());
            this.withConditions(instance.getConditions());
            this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withReadyReplicas(instance.getReadyReplicas());
            this.withReplicas(instance.getReplicas());
        }
    }

    @Override
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    @Override
    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasAvailableReplicas() {
        return this.availableReplicas != null;
    }

    @Override
    public A addToConditions(int index, V1ReplicationControllerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1ReplicationControllerConditionBuilder builder = new V1ReplicationControllerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1ReplicationControllerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1ReplicationControllerConditionBuilder builder = new V1ReplicationControllerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1ReplicationControllerCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1ReplicationControllerCondition item : items) {
            V1ReplicationControllerConditionBuilder builder = new V1ReplicationControllerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1ReplicationControllerCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1ReplicationControllerCondition item : items) {
            V1ReplicationControllerConditionBuilder builder = new V1ReplicationControllerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1ReplicationControllerCondition ... items) {
        for (V1ReplicationControllerCondition item : items) {
            V1ReplicationControllerConditionBuilder builder = new V1ReplicationControllerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1ReplicationControllerCondition> items) {
        for (V1ReplicationControllerCondition item : items) {
            V1ReplicationControllerConditionBuilder builder = new V1ReplicationControllerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V1ReplicationControllerConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1ReplicationControllerConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1ReplicationControllerConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ReplicationControllerCondition> getConditions() {
        return this.conditions != null ? V1ReplicationControllerStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<V1ReplicationControllerCondition> buildConditions() {
        return this.conditions != null ? V1ReplicationControllerStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public V1ReplicationControllerCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1ReplicationControllerCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1ReplicationControllerCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1ReplicationControllerCondition buildMatchingCondition(Predicate<V1ReplicationControllerConditionBuilder> predicate) {
        for (V1ReplicationControllerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1ReplicationControllerConditionBuilder> predicate) {
        for (V1ReplicationControllerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1ReplicationControllerCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1ReplicationControllerCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1ReplicationControllerCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1ReplicationControllerCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1ReplicationControllerStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1ReplicationControllerStatusFluent.ConditionsNested<A> addNewConditionLike(V1ReplicationControllerCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1ReplicationControllerStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1ReplicationControllerCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1ReplicationControllerStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1ReplicationControllerStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1ReplicationControllerStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1ReplicationControllerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1ReplicationControllerConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getFullyLabeledReplicas() {
        return this.fullyLabeledReplicas;
    }

    @Override
    public A withFullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasFullyLabeledReplicas() {
        return this.fullyLabeledReplicas != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    @Override
    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ReplicationControllerStatusFluentImpl that = (V1ReplicationControllerStatusFluentImpl)o;
        if (!Objects.equals(this.availableReplicas, that.availableReplicas)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.fullyLabeledReplicas, that.fullyLabeledReplicas)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.readyReplicas, that.readyReplicas)) {
            return false;
        }
        return Objects.equals(this.replicas, that.replicas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.conditions, this.fullyLabeledReplicas, this.observedGeneration, this.readyReplicas, this.replicas, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableReplicas != null) {
            sb.append("availableReplicas:");
            sb.append(this.availableReplicas + ",");
        }
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.fullyLabeledReplicas != null) {
            sb.append("fullyLabeledReplicas:");
            sb.append(this.fullyLabeledReplicas + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.readyReplicas != null) {
            sb.append("readyReplicas:");
            sb.append(this.readyReplicas + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas);
        }
        sb.append("}");
        return sb.toString();
    }

    class ConditionsNestedImpl<N>
    extends V1ReplicationControllerConditionFluentImpl<V1ReplicationControllerStatusFluent.ConditionsNested<N>>
    implements V1ReplicationControllerStatusFluent.ConditionsNested<N>,
    Nested<N> {
        V1ReplicationControllerConditionBuilder builder;
        int index;

        ConditionsNestedImpl(int index, V1ReplicationControllerCondition item) {
            this.index = index;
            this.builder = new V1ReplicationControllerConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1ReplicationControllerConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ReplicationControllerStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

