/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;

public class OutputChannel {
    @Nullable
    @GuardedBy(value="this")
    private WritableFrameChannel writableChannel;
    @Nullable
    @GuardedBy(value="this")
    private MemoryAllocator frameMemoryAllocator;
    private final Supplier<ReadableFrameChannel> readableChannelSupplier;
    private final boolean readableChannelUsableWhileWriting;
    private final int partitionNumber;

    private OutputChannel(@Nullable WritableFrameChannel writableChannel, @Nullable MemoryAllocator frameMemoryAllocator, Supplier<ReadableFrameChannel> readableChannelSupplier, boolean readableChannelUsableWhileWriting, int partitionNumber) {
        this.writableChannel = writableChannel;
        this.frameMemoryAllocator = frameMemoryAllocator;
        this.readableChannelSupplier = readableChannelSupplier;
        this.readableChannelUsableWhileWriting = readableChannelUsableWhileWriting;
        this.partitionNumber = partitionNumber;
        if (partitionNumber < 0 && partitionNumber != -1) {
            throw new IAE("Invalid partition number [%d]", partitionNumber);
        }
    }

    public static OutputChannel pair(WritableFrameChannel writableChannel, MemoryAllocator frameMemoryAllocator, Supplier<ReadableFrameChannel> readableChannelSupplier, int partitionNumber) {
        return new OutputChannel((WritableFrameChannel)Preconditions.checkNotNull((Object)writableChannel, (Object)"writableChannel"), (MemoryAllocator)Preconditions.checkNotNull((Object)frameMemoryAllocator, (Object)"frameMemoryAllocator"), readableChannelSupplier, false, partitionNumber);
    }

    public static OutputChannel immediatelyReadablePair(WritableFrameChannel writableChannel, MemoryAllocator frameMemoryAllocator, ReadableFrameChannel readableChannel, int partitionNumber) {
        return new OutputChannel((WritableFrameChannel)Preconditions.checkNotNull((Object)writableChannel, (Object)"writableChannel"), (MemoryAllocator)Preconditions.checkNotNull((Object)frameMemoryAllocator, (Object)"frameMemoryAllocator"), () -> readableChannel, true, partitionNumber);
    }

    public static OutputChannel readOnly(ReadableFrameChannel readableChannel, int partitionNumber) {
        return OutputChannel.readOnly(() -> readableChannel, partitionNumber);
    }

    public static OutputChannel readOnly(Supplier<ReadableFrameChannel> readableChannelSupplier, int partitionNumber) {
        return new OutputChannel(null, null, readableChannelSupplier, true, partitionNumber);
    }

    public static OutputChannel nil(int partitionNumber) {
        return new OutputChannel(null, null, () -> ReadableNilFrameChannel.INSTANCE, true, partitionNumber);
    }

    public synchronized WritableFrameChannel getWritableChannel() {
        if (this.writableChannel == null) {
            throw new ISE("Writable channel is not available. The output channel might be marked as read-only, hence no writes are allowed.", new Object[0]);
        }
        return this.writableChannel;
    }

    public synchronized MemoryAllocator getFrameMemoryAllocator() {
        if (this.frameMemoryAllocator == null) {
            throw new ISE("Frame allocator is not available. The output channel might be marked as read-only, hence memory allocator is not required.", new Object[0]);
        }
        return this.frameMemoryAllocator;
    }

    public ReadableFrameChannel getReadableChannel() {
        if (this.isReadableChannelReady()) {
            return this.readableChannelSupplier.get();
        }
        throw new ISE("Readable channel is not ready", new Object[0]);
    }

    public synchronized boolean isReadableChannelReady() {
        return this.readableChannelUsableWhileWriting || this.writableChannel == null || this.writableChannel.isClosed();
    }

    public Supplier<ReadableFrameChannel> getReadableChannelSupplier() {
        return this.readableChannelSupplier;
    }

    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public synchronized OutputChannel mapWritableChannel(Function<WritableFrameChannel, WritableFrameChannel> mapFn) {
        if (this.writableChannel == null) {
            return this;
        }
        return new OutputChannel(mapFn.apply(this.writableChannel), this.frameMemoryAllocator, this.readableChannelSupplier, this.readableChannelUsableWhileWriting, this.partitionNumber);
    }

    public OutputChannel readOnly() {
        return OutputChannel.readOnly(this.readableChannelSupplier, this.partitionNumber);
    }

    public synchronized void convertToReadOnly() {
        this.writableChannel = null;
        this.frameMemoryAllocator = null;
    }
}

