/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.ProtectionDomain;
import org.apache.druid.java.util.common.UnsafeUtils;
import org.apache.druid.utils.JvmUtils;

public class DefineClassUtils {
    private static final MethodHandle DEFINE_CLASS;
    private static final Exception DEFINE_CLASS_NOT_SUPPORTED_EXCEPTION;

    private static MethodHandle defineClassJava9(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        MethodHandle defineClass = lookup.unreflect(MethodHandles.Lookup.class.getMethod("defineClass", byte[].class));
        MethodHandle privateLookupIn = lookup.findStatic(MethodHandles.class, "privateLookupIn", MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class));
        privateLookupIn = MethodHandles.insertArguments(privateLookupIn, 1, lookup);
        defineClass = MethodHandles.filterArguments(defineClass, 0, privateLookupIn);
        defineClass = MethodHandles.dropArguments(defineClass, 2, new Class[]{String.class});
        return defineClass;
    }

    private static MethodHandle defineClassJava8(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        MethodHandle defineClass = lookup.findVirtual(UnsafeUtils.theUnsafeClass(), "defineClass", MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class)).bindTo(UnsafeUtils.theUnsafe());
        MethodHandle getProtectionDomain = lookup.unreflect(Class.class.getMethod("getProtectionDomain", new Class[0]));
        MethodHandle getClassLoader = lookup.unreflect(Class.class.getMethod("getClassLoader", new Class[0]));
        defineClass = MethodHandles.filterArguments(defineClass, 5, getProtectionDomain);
        defineClass = MethodHandles.filterArguments(defineClass, 4, getClassLoader);
        defineClass = MethodHandles.permuteArguments(defineClass, MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, Class.class), 0, 1, 2, 3, 4, 4);
        defineClass = MethodHandles.insertArguments(defineClass, 2, 0);
        MethodHandle arrayLength = lookup.findStatic(lookup.lookupClass(), "getArrayLength", MethodType.methodType(Integer.TYPE, byte[].class));
        defineClass = MethodHandles.filterArguments(defineClass, 2, arrayLength);
        defineClass = MethodHandles.permuteArguments(defineClass, MethodType.methodType(Class.class, Class.class, byte[].class, String.class), 2, 1, 1, 0);
        return defineClass;
    }

    static int getArrayLength(byte[] bytes) {
        return bytes.length;
    }

    public static Class defineClass(Class<?> targetClass, byte[] byteCode, String className) {
        if (DEFINE_CLASS == null) {
            throw new UnsupportedOperationException("defineClass is not supported on this platform, because internal Java APIs are not compatible with this Druid version", DEFINE_CLASS_NOT_SUPPORTED_EXCEPTION);
        }
        try {
            return DEFINE_CLASS.invokeExact(targetClass, byteCode, className);
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException("Unable to define specialized class: " + className, t);
        }
    }

    static {
        MethodHandle defineClass = null;
        Exception exception = null;
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            defineClass = JvmUtils.isIsJava9Compatible() ? DefineClassUtils.defineClassJava9(lookup) : DefineClassUtils.defineClassJava8(lookup);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            exception = e;
        }
        if (defineClass != null) {
            DEFINE_CLASS = defineClass;
            DEFINE_CLASS_NOT_SUPPORTED_EXCEPTION = null;
        } else {
            DEFINE_CLASS = null;
            DEFINE_CLASS_NOT_SUPPORTED_EXCEPTION = exception;
        }
    }
}

