/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.query.rowsandcols.EmptyRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.concrete.ColumnBasedFrameRowsAndColumns;
import org.apache.druid.segment.CloseableShapeshifter;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.column.RowSignature;

public class CursorFactoryRowsAndColumns
implements CloseableShapeshifter,
RowsAndColumns {
    private final CursorFactory cursorFactory;
    private final Supplier<RowsAndColumns> materialized;

    public CursorFactoryRowsAndColumns(CursorFactory cursorFactory) {
        this.cursorFactory = cursorFactory;
        this.materialized = Suppliers.memoize(() -> CursorFactoryRowsAndColumns.materialize(cursorFactory));
    }

    @Override
    public <T> T as(Class<T> clazz) {
        if (CursorFactory.class == clazz) {
            return (T)this.cursorFactory;
        }
        return RowsAndColumns.super.as(clazz);
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.cursorFactory.getRowSignature().getColumnNames();
    }

    @Override
    public int numRows() {
        return ((RowsAndColumns)this.materialized.get()).numRows();
    }

    @Override
    public Column findColumn(String name) {
        return ((RowsAndColumns)this.materialized.get()).findColumn(name);
    }

    @Override
    public void close() {
    }

    @Nonnull
    private static RowsAndColumns materialize(CursorFactory cursorFactory) {
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            FrameWriter writer;
            RowSignature rowSignature;
            block19: {
                Cursor cursor = cursorHolder.asCursor();
                rowSignature = cursorFactory.getRowSignature();
                if (cursor == null) {
                    EmptyRowsAndColumns emptyRowsAndColumns = new EmptyRowsAndColumns();
                    return emptyRowsAndColumns;
                }
                ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
                FrameWriterFactory frameWriterFactory = FrameWriters.makeColumnBasedFrameWriterFactory(new ArenaMemoryAllocatorFactory(0xC800000), rowSignature, Collections.emptyList());
                writer = frameWriterFactory.newFrameWriter(columnSelectorFactory);
                try {
                    while (!cursor.isDoneOrInterrupted()) {
                        writer.addSelection();
                        cursor.advance();
                    }
                    if (writer != null) break block19;
                    EmptyRowsAndColumns emptyRowsAndColumns = new EmptyRowsAndColumns();
                    if (writer != null) {
                        writer.close();
                    }
                    return emptyRowsAndColumns;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            byte[] bytes = writer.toByteArray();
            ColumnBasedFrameRowsAndColumns columnBasedFrameRowsAndColumns = new ColumnBasedFrameRowsAndColumns(Frame.wrap(bytes), rowSignature);
            if (writer != null) {
                writer.close();
            }
            return columnBasedFrameRowsAndColumns;
        }
    }
}

