/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.common.config.NullHandling;

public class SearchHit
implements Comparable<SearchHit> {
    private final String dimension;
    private final String value;
    private final Integer count;

    @JsonCreator
    public SearchHit(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="value") String value, @JsonProperty(value="count") Integer count) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension);
        this.value = NullHandling.nullToEmptyIfNeeded(value);
        this.count = count;
    }

    public SearchHit(String dimension, String value) {
        this(dimension, value, null);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public Integer getCount() {
        return this.count;
    }

    @Override
    public int compareTo(SearchHit o) {
        int retVal = this.dimension.compareTo(o.dimension);
        if (retVal == 0) {
            retVal = this.value.compareTo(o.value);
        }
        return retVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchHit searchHit = (SearchHit)o;
        if (this.dimension != null ? !this.dimension.equals(searchHit.dimension) : searchHit.dimension != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(searchHit.value) : searchHit.value != null);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Hit{dimension='" + this.dimension + '\'' + ", value='" + this.value + '\'' + (this.count != null ? ", count='" + this.count + '\'' : "") + '}';
    }
}

