/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.NestedDataColumnIndexerV4;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorHolder;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;
import org.apache.druid.segment.incremental.IncrementalIndexRowSelector;
import org.apache.druid.segment.projections.QueryableProjection;

public class IncrementalIndexCursorFactory
implements CursorFactory {
    private static final ColumnCapabilities.CoercionLogic COERCE_LOGIC = new ColumnCapabilities.CoercionLogic(){

        @Override
        public boolean dictionaryEncoded() {
            return false;
        }

        @Override
        public boolean dictionaryValuesSorted() {
            return false;
        }

        @Override
        public boolean dictionaryValuesUnique() {
            return true;
        }

        @Override
        public boolean multipleValues() {
            return true;
        }

        @Override
        public boolean hasNulls() {
            return true;
        }
    };
    private final IncrementalIndex index;

    public IncrementalIndexCursorFactory(IncrementalIndex index) {
        this.index = index;
    }

    @Override
    public CursorHolder makeCursorHolder(CursorBuildSpec spec) {
        final QueryableProjection<IncrementalIndexRowSelector> projection = this.index.getProjection(spec);
        if (projection == null) {
            return new IncrementalIndexCursorHolder(this.index, spec);
        }
        return new IncrementalIndexCursorHolder(projection.getRowSelector(), projection.getCursorBuildSpec()){

            @Override
            public ColumnSelectorFactory makeSelectorFactory(CursorBuildSpec buildSpec, IncrementalIndexRowHolder currEntry) {
                return projection.wrapColumnSelectorFactory(super.makeSelectorFactory(buildSpec, currEntry));
            }

            @Override
            public boolean isPreAggregated() {
                return true;
            }

            @Override
            public List<AggregatorFactory> getAggregatorsForPreAggregated() {
                return projection.getCursorBuildSpec().getAggregators();
            }
        };
    }

    @Override
    public RowSignature getRowSignature() {
        RowSignature.Builder builder = RowSignature.builder();
        for (String column : Iterables.concat(this.index.getDimensionNames(true), this.index.getMetricNames())) {
            builder.add(column, ColumnType.fromCapabilities(this.index.getColumnCapabilities(column)));
        }
        return builder.build();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return IncrementalIndexCursorFactory.snapshotColumnCapabilities(this.index, column);
    }

    static ColumnCapabilities snapshotColumnCapabilities(IncrementalIndexRowSelector selector, String column) {
        IncrementalIndex.DimensionDesc desc = selector.getDimension(column);
        if (desc != null && desc.getIndexer() instanceof NestedDataColumnIndexerV4) {
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.NESTED_DATA);
        }
        return ColumnCapabilitiesImpl.snapshot(selector.getColumnCapabilities(column), COERCE_LOGIC);
    }
}

