/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class PossiblyNullColumnValueSelector<T>
implements ColumnValueSelector<T> {
    private final ColumnValueSelector<T> baseSelector;
    private final BooleanSupplier beNull;
    @Nullable
    private final T nullValue;

    PossiblyNullColumnValueSelector(ColumnValueSelector<T> baseSelector, BooleanSupplier beNull) {
        this.baseSelector = baseSelector;
        this.beNull = beNull;
        this.nullValue = NullHandling.defaultValueForClass(baseSelector.classOfObject());
    }

    @Override
    public double getDouble() {
        return this.beNull.getAsBoolean() ? NullHandling.ZERO_DOUBLE.doubleValue() : this.baseSelector.getDouble();
    }

    @Override
    public float getFloat() {
        return this.beNull.getAsBoolean() ? NullHandling.ZERO_FLOAT.floatValue() : this.baseSelector.getFloat();
    }

    @Override
    public long getLong() {
        return this.beNull.getAsBoolean() ? NullHandling.ZERO_LONG.longValue() : this.baseSelector.getLong();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        this.baseSelector.inspectRuntimeShape(inspector);
        inspector.visit("beNull", this.beNull);
    }

    @Override
    @Nullable
    public T getObject() {
        return this.beNull.getAsBoolean() ? this.nullValue : this.baseSelector.getObject();
    }

    @Override
    public Class<? extends T> classOfObject() {
        return this.baseSelector.classOfObject();
    }

    @Override
    public boolean isNull() {
        return this.beNull.getAsBoolean() || this.baseSelector.isNull();
    }
}

