/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.client.BrokerServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.msq.dart.controller.DartTableInputSpecSlicer;
import org.apache.druid.msq.dart.controller.DartWorkerManager;
import org.apache.druid.msq.dart.worker.DartWorkerClient;
import org.apache.druid.msq.dart.worker.WorkerId;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.exec.ControllerContext;
import org.apache.druid.msq.exec.ControllerMemoryParameters;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.exec.WorkerFailureListener;
import org.apache.druid.msq.exec.WorkerManager;
import org.apache.druid.msq.indexing.IndexerControllerContext;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.destination.TaskReportMSQDestination;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.kernel.controller.ControllerQueryKernelConfig;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.QueryKitSpec;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;

public class DartControllerContext
implements ControllerContext {
    public static final int DEFAULT_MAX_CONCURRENT_STAGES = 2;
    public static final int DEFAULT_TARGET_PARTITIONS_PER_WORKER = 1;
    public static final String CTX_MAX_NON_LEAF_WORKER_COUNT = "maxNonLeafWorkers";
    public static final int DEFAULT_MAX_NON_LEAF_WORKER_COUNT = 1;
    private final Injector injector;
    private final ObjectMapper jsonMapper;
    private final DruidNode selfNode;
    private final DartWorkerClient workerClient;
    private final BrokerServerView serverView;
    private final MemoryIntrospector memoryIntrospector;
    private final ServiceMetricEvent.Builder metricBuilder;
    private final ServiceEmitter emitter;

    public DartControllerContext(Injector injector, ObjectMapper jsonMapper, DruidNode selfNode, DartWorkerClient workerClient, MemoryIntrospector memoryIntrospector, BrokerServerView serverView, ServiceEmitter emitter) {
        this.injector = injector;
        this.jsonMapper = jsonMapper;
        this.selfNode = selfNode;
        this.workerClient = workerClient;
        this.serverView = serverView;
        this.memoryIntrospector = memoryIntrospector;
        this.metricBuilder = new ServiceMetricEvent.Builder();
        this.emitter = emitter;
    }

    @Override
    public ControllerQueryKernelConfig queryKernelConfig(String queryId, MSQSpec querySpec) {
        List servers = this.serverView.getDruidServerMetadatas();
        ArrayList<String> workerIds = new ArrayList<String>(servers.size());
        for (DruidServerMetadata server : servers) {
            if (server.getType() != ServerType.HISTORICAL) continue;
            workerIds.add(WorkerId.fromDruidServerMetadata(server, queryId).toString());
        }
        Collections.shuffle(workerIds);
        ControllerMemoryParameters memoryParameters = ControllerMemoryParameters.createProductionInstance(this.memoryIntrospector, workerIds.size());
        int maxConcurrentStages = MultiStageQueryContext.getMaxConcurrentStagesWithDefault(querySpec.getQuery().context(), 2);
        return ControllerQueryKernelConfig.builder().controllerHost(this.selfNode.getHostAndPortToUse()).workerIds(workerIds).pipeline(maxConcurrentStages > 1).destination(TaskReportMSQDestination.instance()).maxConcurrentStages(maxConcurrentStages).maxRetainedPartitionSketchBytes(memoryParameters.getPartitionStatisticsMaxRetainedBytes()).workerContextMap(IndexerControllerContext.makeWorkerContextMap(querySpec, false, maxConcurrentStages)).build();
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public void emitMetric(String metric, Number value) {
        this.emitter.emit((ServiceEventBuilder)this.metricBuilder.setMetric(metric, value));
    }

    @Override
    public DruidNode selfNode() {
        return this.selfNode;
    }

    @Override
    public InputSpecSlicer newTableInputSpecSlicer(WorkerManager workerManager) {
        return DartTableInputSpecSlicer.createFromWorkerIds(workerManager.getWorkerIds(), (TimelineServerView)this.serverView);
    }

    @Override
    public TaskActionClient taskActionClient() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WorkerManager newWorkerManager(String queryId, MSQSpec querySpec, ControllerQueryKernelConfig queryKernelConfig, WorkerFailureListener workerFailureListener) {
        return new DartWorkerManager(queryKernelConfig.getWorkerIds(), this.workerClient);
    }

    @Override
    public DartWorkerClient newWorkerClient() {
        return this.workerClient;
    }

    @Override
    public void registerController(Controller controller, Closer closer) {
        closer.register((Closeable)this.workerClient);
    }

    @Override
    public QueryKitSpec makeQueryKitSpec(QueryKit<Query<?>> queryKit, String queryId, MSQSpec querySpec, ControllerQueryKernelConfig queryKernelConfig) {
        QueryContext queryContext = querySpec.getQuery().context();
        return new QueryKitSpec(queryKit, queryId, queryKernelConfig.getWorkerIds().size(), queryContext.getInt(CTX_MAX_NON_LEAF_WORKER_COUNT, 1), MultiStageQueryContext.getTargetPartitionsPerWorkerWithDefault(queryContext, 1));
    }

    @Override
    public TaskLockType taskLockType() {
        throw DruidException.defensive((String)"TaskLockType is not used with class[%s]", (Object[])new Object[]{this.getClass().getName()});
    }
}

