/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;

public class PartialKeyStatistics
implements ControllerMessage {
    private final StageId stageId;
    private final int workerNumber;
    private final PartialKeyStatisticsInformation payload;

    @JsonCreator
    public PartialKeyStatistics(@JsonProperty(value="stage") StageId stageId, @JsonProperty(value="worker") int workerNumber, @JsonProperty(value="payload") PartialKeyStatisticsInformation payload) {
        this.stageId = (StageId)Preconditions.checkNotNull((Object)stageId, (Object)"stageId");
        this.workerNumber = workerNumber;
        this.payload = payload;
    }

    @Override
    public String getQueryId() {
        return this.stageId.getQueryId();
    }

    @JsonProperty(value="stage")
    public StageId getStageId() {
        return this.stageId;
    }

    @JsonProperty(value="worker")
    public int getWorkerNumber() {
        return this.workerNumber;
    }

    @JsonProperty
    public PartialKeyStatisticsInformation getPayload() {
        return this.payload;
    }

    @Override
    public void handle(Controller controller) {
        controller.updatePartialKeyStatisticsInformation(this.stageId.getStageNumber(), this.workerNumber, this.payload);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialKeyStatistics that = (PartialKeyStatistics)o;
        return this.workerNumber == that.workerNumber && Objects.equals(this.stageId, that.stageId) && Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return Objects.hash(this.stageId, this.workerNumber, this.payload);
    }

    public String toString() {
        return "PartialKeyStatistics{stageId=" + this.stageId + ", workerNumber=" + this.workerNumber + ", payload=" + this.payload + '}';
    }
}

