/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.exec.DataServerQueryHandler;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.kernel.StagePartition;

public class ReadableInput {
    @Nullable
    private final SegmentWithDescriptor segment;
    @Nullable
    private final DataServerQueryHandler dataServerQuery;
    @Nullable
    private final ReadableFrameChannel channel;
    @Nullable
    private final FrameReader frameReader;
    @Nullable
    private final StagePartition stagePartition;

    private ReadableInput(@Nullable SegmentWithDescriptor segment, @Nullable DataServerQueryHandler dataServerQuery, @Nullable ReadableFrameChannel channel, @Nullable FrameReader frameReader, @Nullable StagePartition stagePartition) {
        this.segment = segment;
        this.dataServerQuery = dataServerQuery;
        this.channel = channel;
        this.frameReader = frameReader;
        this.stagePartition = stagePartition;
        if (segment == null && channel == null && dataServerQuery == null) {
            throw new ISE("Provide 'segment', 'dataServerQuery' or 'channel'", new Object[0]);
        }
    }

    public static ReadableInput segment(SegmentWithDescriptor segment) {
        return new ReadableInput((SegmentWithDescriptor)Preconditions.checkNotNull((Object)segment, (Object)"segment"), null, null, null, null);
    }

    public static ReadableInput dataServerQuery(DataServerQueryHandler dataServerQueryHandler) {
        return new ReadableInput(null, (DataServerQueryHandler)Preconditions.checkNotNull((Object)dataServerQueryHandler, (Object)"dataServerQuery"), null, null, null);
    }

    public static ReadableInput channel(ReadableFrameChannel channel, FrameReader frameReader, @Nullable StagePartition stagePartition) {
        return new ReadableInput(null, null, (ReadableFrameChannel)Preconditions.checkNotNull((Object)channel, (Object)"channel"), (FrameReader)Preconditions.checkNotNull((Object)frameReader, (Object)"frameReader"), stagePartition);
    }

    public boolean hasSegment() {
        return this.segment != null;
    }

    public boolean hasDataServerQuery() {
        return this.dataServerQuery != null;
    }

    public boolean hasChannel() {
        return this.channel != null;
    }

    public SegmentWithDescriptor getSegment() {
        this.checkIsSegment();
        return this.segment;
    }

    public DataServerQueryHandler getDataServerQuery() {
        this.checkIsDataServerQuery();
        return this.dataServerQuery;
    }

    public ReadableFrameChannel getChannel() {
        this.checkIsChannel();
        return this.channel;
    }

    public FrameReader getChannelFrameReader() {
        this.checkIsChannel();
        return this.frameReader;
    }

    public StagePartition getStagePartition() {
        this.checkIsChannel();
        if (this.stagePartition == null) {
            throw new ISE("Stage-partition is not set for this channel", new Object[0]);
        }
        return this.stagePartition;
    }

    private void checkIsSegment() {
        if (!this.hasSegment()) {
            throw new ISE("Not a segment; cannot call this method", new Object[0]);
        }
    }

    private void checkIsDataServerQuery() {
        if (!this.hasDataServerQuery()) {
            throw new ISE("Not a data server query; cannot call this method", new Object[0]);
        }
    }

    private void checkIsChannel() {
        if (!this.hasChannel()) {
            throw new ISE("Not a channel input; cannot call this method", new Object[0]);
        }
    }
}

