/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class PageInformation {
    private final long id;
    @Nullable
    private final Long numRows;
    @Nullable
    private final Long sizeInBytes;
    @Nullable
    private final Integer worker;
    @Nullable
    private final Integer partition;

    @JsonCreator
    public PageInformation(@JsonProperty(value="id") long id, @JsonProperty(value="numRows") @Nullable Long numRows, @JsonProperty(value="sizeInBytes") @Nullable Long sizeInBytes) {
        this.id = id;
        this.numRows = numRows;
        this.sizeInBytes = sizeInBytes;
        this.worker = null;
        this.partition = null;
    }

    public PageInformation(long id, Long numRows, Long sizeInBytes, Integer worker, Integer partition) {
        this.id = id;
        this.numRows = numRows;
        this.sizeInBytes = sizeInBytes;
        this.worker = worker;
        this.partition = partition;
    }

    @JsonProperty
    public long getId() {
        return this.id;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Long getNumRows() {
        return this.numRows;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Nullable
    @JsonIgnore
    public Integer getWorker() {
        return this.worker;
    }

    @Nullable
    @JsonIgnore
    public Integer getPartition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageInformation that = (PageInformation)o;
        return this.id == that.id && Objects.equals(this.numRows, that.numRows) && Objects.equals(this.sizeInBytes, that.sizeInBytes) && Objects.equals(this.worker, that.worker) && Objects.equals(this.partition, that.partition);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.numRows, this.sizeInBytes, this.worker, this.partition);
    }

    public String toString() {
        return "PageInformation{id=" + this.id + ", numRows=" + this.numRows + ", sizeInBytes=" + this.sizeInBytes + ", worker=" + this.worker + ", partition=" + this.partition + '}';
    }
}

