/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.kafka;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.kafka.common.TopicPartition;

@JsonSerialize(using=KafkaTopicPartitionSerializer.class, keyUsing=KafkaTopicPartitionKeySerializer.class)
@JsonDeserialize(using=KafkaTopicPartitionDeserializer.class, keyUsing=KafkaTopicPartitionKeyDeserializer.class)
public class KafkaTopicPartition {
    private final int partition;
    @Nullable
    private final String topic;
    private final boolean multiTopicPartition;

    public KafkaTopicPartition(boolean multiTopicPartition, @Nullable String topic, int partition) {
        this.partition = partition;
        this.multiTopicPartition = multiTopicPartition;
        if (multiTopicPartition) {
            if (topic == null) {
                throw DruidException.defensive((String)"the topic cannot be null in multi-topic mode of kafka ingestion", (Object[])new Object[0]);
            }
            this.topic = topic;
        } else {
            this.topic = null;
        }
    }

    public int partition() {
        return this.partition;
    }

    public Optional<String> topic() {
        return Optional.ofNullable(this.topic);
    }

    public boolean isMultiTopicPartition() {
        return this.multiTopicPartition;
    }

    public TopicPartition asTopicPartition(String fallbackTopic) {
        return new TopicPartition(this.topic != null ? this.topic : fallbackTopic, this.partition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaTopicPartition that = (KafkaTopicPartition)o;
        return this.partition == that.partition && this.multiTopicPartition == that.multiTopicPartition && Objects.equals(this.topic, that.topic);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.multiTopicPartition, this.topic);
    }

    public String toString() {
        return "KafkaTopicPartition{partition=" + this.partition + ", topic='" + this.topic + '\'' + ", multiTopicPartition=" + this.multiTopicPartition + '}';
    }

    public static KafkaTopicPartition fromString(String str) {
        int index = str.lastIndexOf(58);
        if (index < 0) {
            return new KafkaTopicPartition(false, null, Integer.parseInt(str));
        }
        return new KafkaTopicPartition(true, str.substring(0, index), Integer.parseInt(str.substring(index + 1)));
    }

    public static class KafkaTopicPartitionKeyDeserializer
    extends KeyDeserializer {
        public KafkaTopicPartition deserializeKey(String key, DeserializationContext ctxt) {
            return KafkaTopicPartition.fromString(key);
        }
    }

    public static class KafkaTopicPartitionKeySerializer
    extends JsonSerializer<KafkaTopicPartition> {
        public void serialize(KafkaTopicPartition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (null != value.topic && value.multiTopicPartition) {
                gen.writeFieldName(value.topic + ":" + value.partition);
            } else {
                gen.writeFieldName(String.valueOf(value.partition));
            }
        }

        public Class<KafkaTopicPartition> handledType() {
            return KafkaTopicPartition.class;
        }
    }

    public static class KafkaTopicPartitionSerializer
    extends JsonSerializer<KafkaTopicPartition> {
        public void serialize(KafkaTopicPartition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (null != value.topic && value.multiTopicPartition) {
                gen.writeString(value.topic + ":" + value.partition);
            } else {
                gen.writeString(String.valueOf(value.partition));
            }
        }

        public Class<KafkaTopicPartition> handledType() {
            return KafkaTopicPartition.class;
        }
    }

    public static class KafkaTopicPartitionDeserializer
    extends JsonDeserializer<KafkaTopicPartition> {
        public KafkaTopicPartition deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return KafkaTopicPartition.fromString(p.getValueAsString());
        }

        public Class<KafkaTopicPartition> handledType() {
            return KafkaTopicPartition.class;
        }
    }
}

