/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.SchemaRegistry;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.sync.CatalogUpdateListener;
import org.apache.druid.catalog.sync.MetadataCatalog;
import org.apache.druid.catalog.sync.UpdateEvent;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.logger.Logger;

public class CachedMetadataCatalog
implements MetadataCatalog,
CatalogUpdateListener {
    private static final Logger LOG = new Logger(CachedMetadataCatalog.class);
    public static final int NOT_FETCHED = -1;
    public static final int UNDEFINED = 0;
    private final ConcurrentHashMap<String, SchemaEntry> schemaCache = new ConcurrentHashMap();
    private final MetadataCatalog.CatalogSource base;
    private final SchemaRegistry schemaRegistry;
    private final TableDefnRegistry tableRegistry;

    @Inject
    public CachedMetadataCatalog(MetadataCatalog.CatalogSource catalog, SchemaRegistry schemaRegistry, @Json ObjectMapper jsonMapper) {
        this.base = catalog;
        this.schemaRegistry = schemaRegistry;
        this.tableRegistry = new TableDefnRegistry(jsonMapper);
    }

    @Override
    public TableMetadata getTable(TableId tableId) {
        SchemaEntry schemaEntry = this.entryFor(tableId.schema());
        return schemaEntry == null ? null : schemaEntry.resolveTable(tableId);
    }

    @Override
    public ResolvedTable resolveTable(TableId tableId) {
        TableMetadata table = this.getTable(tableId);
        return table == null ? null : this.tableRegistry.resolve(table.spec());
    }

    @Override
    public List<TableMetadata> tables(String schemaName) {
        SchemaEntry schemaEntry = this.entryFor(schemaName);
        return schemaEntry == null ? null : schemaEntry.tables();
    }

    @Override
    public void updated(UpdateEvent event) {
        SchemaEntry schemaEntry = this.entryFor(event.table.id().schema());
        if (schemaEntry != null) {
            schemaEntry.update(event);
        }
    }

    @Override
    public Set<String> tableNames(String schemaName) {
        SchemaEntry schemaEntry = this.entryFor(schemaName);
        return schemaEntry == null ? Collections.emptySet() : schemaEntry.tableNames();
    }

    @Override
    public void flush() {
        LOG.info("Flush requested", new Object[0]);
        this.schemaCache.clear();
    }

    private SchemaEntry entryFor(String schemaName) {
        return this.schemaCache.computeIfAbsent(schemaName, k -> {
            SchemaRegistry.SchemaSpec schema = this.schemaRegistry.schema(k);
            return schema == null ? null : new SchemaEntry(schema);
        });
    }

    @Override
    public void resync() {
        LOG.info("Resync requested", new Object[0]);
        this.entryFor("druid").resync(this.base);
        this.entryFor("ext").resync(this.base);
    }

    private class SchemaEntry {
        private final SchemaRegistry.SchemaSpec schema;
        private long version = -1L;
        private final ConcurrentHashMap<String, TableEntry> cache = new ConcurrentHashMap();

        protected SchemaEntry(SchemaRegistry.SchemaSpec schema) {
            this.schema = schema;
        }

        protected TableMetadata resolveTable(TableId tableId) {
            TableEntry entry = this.cache.computeIfAbsent(tableId.name(), key -> new TableEntry(CachedMetadataCatalog.this.base.table(tableId)));
            return entry.table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<TableMetadata> tables() {
            if (this.version == 0L) {
                return Collections.emptyList();
            }
            if (this.version == -1L) {
                SchemaEntry schemaEntry = this;
                synchronized (schemaEntry) {
                    List<TableMetadata> catalogTables = CachedMetadataCatalog.this.base.tablesForSchema(this.schema.name());
                    for (TableMetadata table : catalogTables) {
                        this.cache.put(table.id().name(), new TableEntry(table));
                    }
                }
            }
            ArrayList<TableMetadata> orderedTables = new ArrayList<TableMetadata>();
            this.cache.forEach((k, v) -> {
                if (((TableEntry)v).table != null) {
                    orderedTables.add(((TableEntry)v).table);
                }
            });
            orderedTables.sort((e1, e2) -> e1.id().name().compareTo(e2.id().name()));
            return orderedTables;
        }

        public synchronized void update(UpdateEvent event) {
            TableMetadata table = event.table;
            String name = table.id().name();
            switch (event.type) {
                case CREATE: {
                    this.cache.compute(name, (k, v) -> this.computeCreate((TableEntry)v, table));
                    break;
                }
                case UPDATE: {
                    this.cache.compute(name, (k, v) -> this.computeUpdate((TableEntry)v, table));
                    break;
                }
                case DELETE: {
                    this.cache.remove(name);
                    break;
                }
                case COLUMNS_UPDATE: {
                    this.cache.compute(name, (k, v) -> this.computeColumnsUpdate((TableEntry)v, table));
                    break;
                }
                case PROPERTY_UPDATE: {
                    this.cache.compute(name, (k, v) -> this.computePropertiesUpdate((TableEntry)v, table));
                    break;
                }
                default: {
                    return;
                }
            }
            this.version = Math.max(this.version, table.updateTime());
        }

        private TableEntry computeCreate(TableEntry entry, TableMetadata update) {
            if (entry != null && entry.table != null) {
                LOG.warn("Received creation event for existing entry: %s", new Object[]{update.id().sqlName()});
                return this.computeUpdate(entry, update);
            }
            return new TableEntry(update);
        }

        private TableEntry computeUpdate(TableEntry entry, TableMetadata update) {
            if (!this.checkExists(entry, update)) {
                return new TableEntry(update);
            }
            if (!this.checkVersion(entry, update)) {
                return entry;
            }
            return new TableEntry(update);
        }

        private boolean checkExists(TableEntry entry, TableMetadata update) {
            if (entry == null || entry.table == null) {
                LOG.error("Reveived update for missing cache entry: %s", new Object[]{update.id().sqlName()});
                return false;
            }
            return true;
        }

        private TableEntry computeColumnsUpdate(TableEntry entry, TableMetadata update) {
            if (!this.checkExists(entry, update)) {
                return new TableEntry(null);
            }
            if (!this.checkResolved(entry, update, "columns")) {
                return entry;
            }
            if (!this.checkVersion(entry, update)) {
                return entry;
            }
            return new TableEntry(entry.table.withColumns(update));
        }

        private TableEntry computePropertiesUpdate(TableEntry entry, TableMetadata update) {
            if (!this.checkExists(entry, update)) {
                return new TableEntry(null);
            }
            if (!this.checkResolved(entry, update, "properties")) {
                return entry;
            }
            if (!this.checkVersion(entry, update)) {
                return entry;
            }
            return new TableEntry(entry.table.withProperties(update));
        }

        private boolean checkResolved(TableEntry entry, TableMetadata update, String action) {
            if (entry.table == null) {
                LOG.error("Received %s update for unresolved table: %s", new Object[]{action, update.id().sqlName()});
                return false;
            }
            return true;
        }

        private boolean checkVersion(TableEntry entry, TableMetadata update) {
            if (entry.table.updateTime() > update.updateTime()) {
                LOG.warn("Received out-of-order update for table: %s. Cache: %d, update:%d", new Object[]{update.id().sqlName(), entry.table.updateTime(), update.updateTime()});
                return false;
            }
            return true;
        }

        public synchronized Set<String> tableNames() {
            HashSet<String> tables = new HashSet<String>();
            this.cache.forEach((k, v) -> {
                if (((TableEntry)v).table != null) {
                    tables.add((String)k);
                }
            });
            return tables;
        }

        public synchronized void resync(MetadataCatalog.CatalogSource source) {
            List<TableMetadata> tables = source.tablesForSchema(this.schema.name());
            this.cache.clear();
            for (TableMetadata table : tables) {
                this.cache.compute(table.id().name(), (k, v) -> this.computeCreate((TableEntry)v, table));
            }
        }
    }

    private static class TableEntry {
        private final TableMetadata table;

        protected TableEntry(TableMetadata table) {
            this.table = table;
        }
    }
}

