/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.sync;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.sync.MetadataCatalog;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class CatalogClient
implements MetadataCatalog.CatalogSource {
    public static final String SCHEMA_SYNC_PATH = "/druid/coordinator/v1/catalog/sync/schemas/{schema}";
    public static final String TABLE_SYNC_PATH = "/druid/coordinator/v1/catalog/sync/schemas/{schema}/{name}";
    private static final TypeReference<List<TableMetadata>> LIST_OF_TABLE_METADATA_TYPE = new TypeReference<List<TableMetadata>>(){};
    private static final TypeReference<TableMetadata> TABLE_METADATA_TYPE = new TypeReference<TableMetadata>(){};
    private final DruidLeaderClient coordClient;
    private final ObjectMapper smileMapper;
    private final TableDefnRegistry tableRegistry;

    @Inject
    public CatalogClient(@Coordinator DruidLeaderClient coordClient, @Smile ObjectMapper smileMapper, @Json ObjectMapper jsonMapper) {
        this.coordClient = coordClient;
        this.smileMapper = smileMapper;
        this.tableRegistry = new TableDefnRegistry(jsonMapper);
    }

    @Override
    public List<TableMetadata> tablesForSchema(String dbSchema) {
        String url = StringUtils.replace((String)SCHEMA_SYNC_PATH, (String)"{schema}", (String)dbSchema);
        List<TableMetadata> results = this.send(url, LIST_OF_TABLE_METADATA_TYPE);
        return results == null ? Collections.emptyList() : results;
    }

    @Override
    public TableMetadata table(TableId id) {
        String url = StringUtils.replace((String)TABLE_SYNC_PATH, (String)"{schema}", (String)id.schema());
        url = StringUtils.replace((String)url, (String)"{name}", (String)id.name());
        return this.send(url, TABLE_METADATA_TYPE);
    }

    @Override
    public ResolvedTable resolveTable(TableId id) {
        TableMetadata table = this.table(id);
        return table == null ? null : this.tableRegistry.resolve(table.spec());
    }

    private <T> T send(String url, TypeReference<T> typeRef) {
        StringFullResponseHolder responseHolder;
        Request request;
        try {
            request = this.coordClient.makeRequest(HttpMethod.GET, url).addHeader("Accept", "application/json");
        }
        catch (IOException e) {
            throw new ISE("Cannot create catalog sync request", new Object[0]);
        }
        try {
            responseHolder = this.coordClient.go(request);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Failed to send catalog sync", new Object[0]);
        }
        catch (InterruptedException e1) {
            return null;
        }
        if (responseHolder.getStatus().getCode() == HttpResponseStatus.NOT_FOUND.getCode()) {
            return null;
        }
        if (responseHolder.getStatus().getCode() != HttpResponseStatus.OK.getCode()) {
            throw new ISE("Unexpected status from catalog sync: " + responseHolder.getStatus(), new Object[0]);
        }
        try {
            return (T)this.smileMapper.readValue(responseHolder.getContent(), typeRef);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Could not decode the JSON response from catalog sync.", new Object[0]);
        }
    }
}

