/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.SpecificSegmentLockRequest;
import org.joda.time.Interval;

public class SegmentLockTryAcquireAction
implements TaskAction<List<LockResult>> {
    private final TaskLockType type;
    private final Interval interval;
    private final String version;
    private final Set<Integer> partitionIds;

    @JsonCreator
    public SegmentLockTryAcquireAction(@JsonProperty(value="lockType") TaskLockType type, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="partitionIds") Set<Integer> partitionIds) {
        Preconditions.checkState((partitionIds != null && !partitionIds.isEmpty() ? 1 : 0) != 0, (Object)"partitionIds is empty");
        this.type = (TaskLockType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
        this.partitionIds = partitionIds;
    }

    @JsonProperty(value="lockType")
    public TaskLockType getType() {
        return this.type;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public Set<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    @Override
    public TypeReference<List<LockResult>> getReturnTypeReference() {
        return new TypeReference<List<LockResult>>(){};
    }

    @Override
    public List<LockResult> perform(Task task, TaskActionToolbox toolbox) {
        return this.partitionIds.stream().map(partitionId -> toolbox.getTaskLockbox().tryLock(task, new SpecificSegmentLockRequest(this.type, task, this.interval, this.version, (int)partitionId))).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return "SegmentLockTryAcquireAction{type=" + (Object)((Object)this.type) + ", interval=" + this.interval + ", version='" + this.version + '\'' + ", partitionIds=" + this.partitionIds + '}';
    }
}

