/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Period;

public abstract class SeekableStreamIndexTaskTuningConfig
implements AppenderatorConfig {
    private static final boolean DEFAULT_RESET_OFFSET_AUTOMATICALLY = false;
    private static final boolean DEFAULT_SKIP_SEQUENCE_NUMBER_AVAILABILITY_CHECK = false;
    private static final Period DEFAULT_INTERMEDIATE_PERSIST_PERIOD = new Period((Object)"PT10M");
    private static final IndexSpec DEFAULT_INDEX_SPEC = IndexSpec.DEFAULT;
    private static final Boolean DEFAULT_REPORT_PARSE_EXCEPTIONS = Boolean.FALSE;
    private static final long DEFAULT_HANDOFF_CONDITION_TIMEOUT = Duration.ofMinutes(15L).toMillis();
    private final AppendableIndexSpec appendableIndexSpec;
    private final int maxRowsInMemory;
    private final long maxBytesInMemory;
    private final boolean skipBytesInMemoryOverheadCheck;
    private final DynamicPartitionsSpec partitionsSpec;
    private final Period intermediatePersistPeriod;
    private final File basePersistDirectory;
    @Deprecated
    private final int maxPendingPersists;
    private final IndexSpec indexSpec;
    private final IndexSpec indexSpecForIntermediatePersists;
    private final boolean reportParseExceptions;
    private final long handoffConditionTimeout;
    private final boolean resetOffsetAutomatically;
    @Nullable
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
    private final Period intermediateHandoffPeriod;
    private final boolean skipSequenceNumberAvailabilityCheck;
    private final boolean logParseExceptions;
    private final int maxParseExceptions;
    private final int maxSavedParseExceptions;
    private final int numPersistThreads;

    public SeekableStreamIndexTaskTuningConfig(@Nullable AppendableIndexSpec appendableIndexSpec, @Nullable Integer maxRowsInMemory, @Nullable Long maxBytesInMemory, @Nullable Boolean skipBytesInMemoryOverheadCheck, @Nullable Integer maxRowsPerSegment, @Nullable Long maxTotalRows, @Nullable Period intermediatePersistPeriod, @Nullable File basePersistDirectory, @Nullable Integer maxPendingPersists, @Nullable IndexSpec indexSpec, @Nullable IndexSpec indexSpecForIntermediatePersists, @Deprecated @Nullable Boolean reportParseExceptions, @Nullable Long handoffConditionTimeout, @Nullable Boolean resetOffsetAutomatically, Boolean skipSequenceNumberAvailabilityCheck, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @Nullable Period intermediateHandoffPeriod, @Nullable Boolean logParseExceptions, @Nullable Integer maxParseExceptions, @Nullable Integer maxSavedParseExceptions, @Nullable Integer numPersistThreads) {
        this.appendableIndexSpec = appendableIndexSpec == null ? DEFAULT_APPENDABLE_INDEX : appendableIndexSpec;
        this.maxRowsInMemory = maxRowsInMemory == null ? 150000 : maxRowsInMemory;
        this.partitionsSpec = new DynamicPartitionsSpec(maxRowsPerSegment, maxTotalRows);
        this.maxBytesInMemory = maxBytesInMemory == null ? 0L : maxBytesInMemory;
        this.skipBytesInMemoryOverheadCheck = skipBytesInMemoryOverheadCheck == null ? false : skipBytesInMemoryOverheadCheck;
        this.intermediatePersistPeriod = intermediatePersistPeriod == null ? DEFAULT_INTERMEDIATE_PERSIST_PERIOD : intermediatePersistPeriod;
        this.basePersistDirectory = basePersistDirectory;
        this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
        this.indexSpec = indexSpec == null ? DEFAULT_INDEX_SPEC : indexSpec;
        this.indexSpecForIntermediatePersists = indexSpecForIntermediatePersists == null ? this.indexSpec : indexSpecForIntermediatePersists;
        this.reportParseExceptions = reportParseExceptions == null ? DEFAULT_REPORT_PARSE_EXCEPTIONS : reportParseExceptions;
        this.handoffConditionTimeout = handoffConditionTimeout == null ? DEFAULT_HANDOFF_CONDITION_TIMEOUT : handoffConditionTimeout;
        this.resetOffsetAutomatically = resetOffsetAutomatically == null ? false : resetOffsetAutomatically;
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        this.intermediateHandoffPeriod = intermediateHandoffPeriod == null ? new Period().withDays(Integer.MAX_VALUE) : intermediateHandoffPeriod;
        boolean bl = this.skipSequenceNumberAvailabilityCheck = skipSequenceNumberAvailabilityCheck == null ? false : skipSequenceNumberAvailabilityCheck;
        if (this.reportParseExceptions) {
            this.maxParseExceptions = 0;
            this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : Math.min(1, maxSavedParseExceptions);
        } else {
            this.maxParseExceptions = maxParseExceptions == null ? Integer.MAX_VALUE : maxParseExceptions;
            this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : maxSavedParseExceptions;
        }
        this.logParseExceptions = logParseExceptions == null ? false : logParseExceptions;
        this.numPersistThreads = numPersistThreads == null ? 1 : Math.max(numPersistThreads, 1);
    }

    @JsonProperty
    public AppendableIndexSpec getAppendableIndexSpec() {
        return this.appendableIndexSpec;
    }

    @JsonProperty
    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @JsonProperty
    public long getMaxBytesInMemory() {
        return this.maxBytesInMemory;
    }

    @JsonProperty
    public boolean isSkipBytesInMemoryOverheadCheck() {
        return this.skipBytesInMemoryOverheadCheck;
    }

    @JsonProperty
    public Integer getMaxRowsPerSegment() {
        return this.partitionsSpec.getMaxRowsPerSegment();
    }

    @JsonProperty
    @Nullable
    public Long getMaxTotalRows() {
        return this.partitionsSpec.getMaxTotalRows();
    }

    public DynamicPartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @JsonProperty
    public Period getIntermediatePersistPeriod() {
        return this.intermediatePersistPeriod;
    }

    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    @JsonProperty
    @Deprecated
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @JsonProperty
    public IndexSpec getIndexSpecForIntermediatePersists() {
        return this.indexSpecForIntermediatePersists;
    }

    @JsonProperty
    public boolean isReportParseExceptions() {
        return this.reportParseExceptions;
    }

    @JsonProperty
    public long getHandoffConditionTimeout() {
        return this.handoffConditionTimeout;
    }

    @JsonProperty
    public boolean isResetOffsetAutomatically() {
        return this.resetOffsetAutomatically;
    }

    @JsonProperty
    @Nullable
    public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
        return this.segmentWriteOutMediumFactory;
    }

    @JsonProperty
    public Period getIntermediateHandoffPeriod() {
        return this.intermediateHandoffPeriod;
    }

    @JsonProperty
    public boolean isLogParseExceptions() {
        return this.logParseExceptions;
    }

    @JsonProperty
    public int getMaxParseExceptions() {
        return this.maxParseExceptions;
    }

    @JsonProperty
    public int getMaxSavedParseExceptions() {
        return this.maxSavedParseExceptions;
    }

    @JsonProperty
    public boolean isSkipSequenceNumberAvailabilityCheck() {
        return this.skipSequenceNumberAvailabilityCheck;
    }

    @JsonProperty
    public int getNumPersistThreads() {
        return this.numPersistThreads;
    }

    public abstract SeekableStreamIndexTaskTuningConfig withBasePersistDirectory(File var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeekableStreamIndexTaskTuningConfig that = (SeekableStreamIndexTaskTuningConfig)o;
        return Objects.equals(this.appendableIndexSpec, that.appendableIndexSpec) && this.maxRowsInMemory == that.maxRowsInMemory && this.maxBytesInMemory == that.maxBytesInMemory && this.skipBytesInMemoryOverheadCheck == that.skipBytesInMemoryOverheadCheck && this.maxPendingPersists == that.maxPendingPersists && this.reportParseExceptions == that.reportParseExceptions && this.handoffConditionTimeout == that.handoffConditionTimeout && this.resetOffsetAutomatically == that.resetOffsetAutomatically && this.skipSequenceNumberAvailabilityCheck == that.skipSequenceNumberAvailabilityCheck && this.logParseExceptions == that.logParseExceptions && this.maxParseExceptions == that.maxParseExceptions && this.maxSavedParseExceptions == that.maxSavedParseExceptions && this.numPersistThreads == that.numPersistThreads && Objects.equals(this.partitionsSpec, that.partitionsSpec) && Objects.equals(this.intermediatePersistPeriod, that.intermediatePersistPeriod) && Objects.equals(this.basePersistDirectory, that.basePersistDirectory) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.indexSpecForIntermediatePersists, that.indexSpecForIntermediatePersists) && Objects.equals(this.segmentWriteOutMediumFactory, that.segmentWriteOutMediumFactory) && Objects.equals(this.intermediateHandoffPeriod, that.intermediateHandoffPeriod);
    }

    public int hashCode() {
        return Objects.hash(this.appendableIndexSpec, this.maxRowsInMemory, this.maxBytesInMemory, this.skipBytesInMemoryOverheadCheck, this.partitionsSpec, this.intermediatePersistPeriod, this.basePersistDirectory, this.maxPendingPersists, this.indexSpec, this.indexSpecForIntermediatePersists, this.reportParseExceptions, this.handoffConditionTimeout, this.resetOffsetAutomatically, this.segmentWriteOutMediumFactory, this.intermediateHandoffPeriod, this.skipSequenceNumberAvailabilityCheck, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions, this.numPersistThreads);
    }

    public abstract String toString();
}

