/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.calcite.avatica.Meta;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.avatica.AbstractDruidJdbcStatement;
import org.apache.druid.sql.avatica.DruidMeta;

public class DruidJdbcResultSet
implements Closeable {
    private static final Logger LOG = new Logger(DruidJdbcResultSet.class);
    private final ExecutorService queryExecutor;
    private final DirectStatement stmt;
    private final long maxRowCount;
    private final ResultFetcherFactory fetcherFactory;
    private State state = State.NEW;
    private Meta.Signature signature;
    private ResultFetcher fetcher;
    private Future<Meta.Frame> fetchFuture;
    private int nextFetchOffset;

    public DruidJdbcResultSet(AbstractDruidJdbcStatement jdbcStatement, DirectStatement stmt, long maxRowCount, ResultFetcherFactory fetcherFactory) {
        this.stmt = stmt;
        this.maxRowCount = maxRowCount;
        this.fetcherFactory = fetcherFactory;
        this.queryExecutor = Execs.singleThreaded((String)StringUtils.format((String)"JDBCQueryExecutor-connection-%s-statement-%d", (Object[])new Object[]{StringUtils.encodeForFormat((String)jdbcStatement.getConnectionId()), jdbcStatement.getStatementId()}));
    }

    public synchronized void execute() {
        this.ensure(State.NEW);
        try {
            this.state = State.RUNNING;
            Yielder yielder = this.queryExecutor.submit(() -> Yielders.each((Sequence)this.stmt.execute().getResults())).get();
            this.fetcher = this.fetcherFactory.newFetcher(this.maxRowCount >= 0L && this.maxRowCount <= Integer.MAX_VALUE ? (int)this.maxRowCount : Integer.MAX_VALUE, (Yielder<Object[]>)yielder);
            this.signature = AbstractDruidJdbcStatement.createSignature(this.stmt.prepareResult(), this.stmt.query().sql());
            LOG.debug("Opened result set [%s]", new Object[]{this.stmt.sqlQueryId()});
        }
        catch (ExecutionException e) {
            throw this.closeAndPropagateThrowable(e.getCause());
        }
        catch (Throwable t) {
            throw this.closeAndPropagateThrowable(t);
        }
    }

    public synchronized boolean isDone() {
        return this.state == State.DONE;
    }

    public synchronized Meta.Signature getSignature() {
        this.ensure(State.RUNNING, State.DONE);
        return this.signature;
    }

    public synchronized Meta.Frame nextFrame(long fetchOffset, int fetchMaxRowCount) {
        Future<Meta.Frame> future;
        this.ensure(State.RUNNING, State.DONE);
        if (fetchOffset != (long)this.nextFetchOffset) {
            throw new IAE("Druid can only fetch forward. Requested offset of %,d != current offset %,d", new Object[]{fetchOffset, this.nextFetchOffset});
        }
        if (this.state == State.DONE) {
            LOG.debug("EOF at offset %,d for result set [%s]", new Object[]{fetchOffset, this.stmt.sqlQueryId()});
            return new Meta.Frame((long)this.fetcher.offset(), true, Collections.emptyList());
        }
        if (this.fetchFuture == null) {
            this.fetcher.setBatchSize(fetchMaxRowCount);
            future = this.queryExecutor.submit(this.fetcher);
        } else {
            future = this.fetchFuture;
            this.fetchFuture = null;
        }
        try {
            Meta.Frame result = future.get(this.fetcherFactory.fetchTimeoutMs(), TimeUnit.MILLISECONDS);
            LOG.debug("Fetched batch at offset %,d for result set [%s]", new Object[]{fetchOffset, this.stmt.sqlQueryId()});
            if (result.done) {
                this.state = State.DONE;
            }
            this.nextFetchOffset = this.fetcher.offset;
            return result;
        }
        catch (InterruptedException | CancellationException e) {
            throw this.closeAndPropagateThrowable(e);
        }
        catch (ExecutionException e) {
            throw this.closeAndPropagateThrowable(e.getCause());
        }
        catch (TimeoutException e) {
            LOG.debug("Timeout of batch at offset %,d for result set [%s]", new Object[]{fetchOffset, this.stmt.sqlQueryId()});
            this.fetchFuture = future;
            return new Meta.Frame((long)this.nextFetchOffset, false, Collections.emptyList());
        }
    }

    public synchronized long getCurrentOffset() {
        this.ensure(State.RUNNING, State.DONE);
        return this.fetcher.offset;
    }

    @GuardedBy(value="this")
    private void ensure(State ... desiredStates) {
        for (State desiredState : desiredStates) {
            if (this.state != desiredState) continue;
            return;
        }
        throw new ISE("Invalid action for state [%s]", new Object[]{this.state});
    }

    private RuntimeException closeAndPropagateThrowable(Throwable t) {
        DruidMeta.logFailure(t);
        this.stmt.reporter().failed(t);
        try {
            this.close();
        }
        catch (Throwable t1) {
            t.addSuppressed(t1);
        }
        finally {
            this.state = State.FAILED;
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t);
    }

    @Override
    public synchronized void close() {
        if (this.state == State.NEW) {
            this.state = State.CLOSED;
        }
        if (this.state == State.CLOSED || this.state == State.FAILED) {
            return;
        }
        LOG.debug("Closing result set [%s]", new Object[]{this.stmt.sqlQueryId()});
        this.state = State.CLOSED;
        try {
            if (this.fetchFuture != null) {
                try {
                    this.fetchFuture.cancel(true);
                    this.fetchFuture.get();
                }
                catch (Exception exception) {
                }
                finally {
                    this.fetchFuture = null;
                }
            }
            if (this.fetcher != null) {
                Yielder theYielder = this.fetcher.yielder;
                this.fetcher = null;
                this.queryExecutor.submit(() -> {
                    theYielder.close();
                    return null;
                }).get();
                this.queryExecutor.shutdownNow();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.stmt.close();
        }
    }

    private static enum State {
        NEW,
        RUNNING,
        DONE,
        FAILED,
        CLOSED;

    }

    public static class ResultFetcherFactory {
        final int fetchTimeoutMs;

        public ResultFetcherFactory(int fetchTimeoutMs) {
            this.fetchTimeoutMs = Math.max(1000, fetchTimeoutMs);
        }

        public int fetchTimeoutMs() {
            return this.fetchTimeoutMs;
        }

        public ResultFetcher newFetcher(int limit, Yielder<Object[]> yielder) {
            return new ResultFetcher(limit, yielder);
        }
    }

    public static class ResultFetcher
    implements Callable<Meta.Frame> {
        private final int limit;
        private int batchSize;
        private int offset;
        private Yielder<Object[]> yielder;

        public ResultFetcher(int limit, Yielder<Object[]> yielder) {
            this.limit = limit;
            this.yielder = yielder;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }

        public int offset() {
            return this.offset;
        }

        @Override
        public Meta.Frame call() {
            int rowCount;
            Preconditions.checkState((this.batchSize > 0 ? 1 : 0) != 0);
            int batchLimit = Math.min(this.limit - this.offset, this.batchSize);
            ArrayList<Object> rows = new ArrayList<Object>(batchLimit);
            for (rowCount = 0; !this.yielder.isDone() && rowCount < batchLimit; ++rowCount) {
                rows.add(this.yielder.get());
                this.yielder = this.yielder.next(null);
            }
            Meta.Frame result = new Meta.Frame((long)this.offset, this.yielder.isDone(), rows);
            this.offset += rowCount;
            return result;
        }
    }
}

