/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.PruneEmptyRules;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.sql.calcite.external.ExternalTableScanRule;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rule.AggregatePullUpLookupRule;
import org.apache.druid.sql.calcite.rule.CaseToCoalesceRule;
import org.apache.druid.sql.calcite.rule.CoalesceLookupRule;
import org.apache.druid.sql.calcite.rule.DruidLogicalValuesRule;
import org.apache.druid.sql.calcite.rule.DruidRelToDruidRule;
import org.apache.druid.sql.calcite.rule.DruidRules;
import org.apache.druid.sql.calcite.rule.DruidTableScanRule;
import org.apache.druid.sql.calcite.rule.ExtensionCalciteRuleProvider;
import org.apache.druid.sql.calcite.rule.FilterDecomposeCoalesceRule;
import org.apache.druid.sql.calcite.rule.FilterDecomposeConcatRule;
import org.apache.druid.sql.calcite.rule.FilterJoinExcludePushToChildRule;
import org.apache.druid.sql.calcite.rule.FixIncorrectInExpansionTypes;
import org.apache.druid.sql.calcite.rule.FlattenConcatRule;
import org.apache.druid.sql.calcite.rule.ProjectAggregatePruneUnusedCallRule;
import org.apache.druid.sql.calcite.rule.ReverseLookupRule;
import org.apache.druid.sql.calcite.rule.RewriteFirstValueLastValueRule;
import org.apache.druid.sql.calcite.rule.SortCollapseRule;
import org.apache.druid.sql.calcite.rule.logical.DruidAggregateRemoveRedundancyRule;
import org.apache.druid.sql.calcite.rule.logical.DruidLogicalRules;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.hook.DruidHook;

public class CalciteRulesManager {
    private static final Logger log = new Logger(CalciteRulesManager.class);
    public static final int DRUID_CONVENTION_RULES = 0;
    public static final int BINDABLE_CONVENTION_RULES = 1;
    public static final int DRUID_DAG_CONVENTION_RULES = 2;
    private static final String HEP_DEFAULT_MATCH_LIMIT_CONFIG_STRING = "druid.sql.planner.hepMatchLimit";
    private static final int HEP_DEFAULT_MATCH_LIMIT = Integer.parseInt(System.getProperty("druid.sql.planner.hepMatchLimit", "1200"));
    public static final String BLOAT_PROPERTY = "sqlPlannerBloat";
    public static final int DEFAULT_BLOAT = 1000;
    private static final List<RelOptRule> BASE_RULES = ImmutableList.of((Object)CoreRules.AGGREGATE_STAR_TABLE, (Object)CoreRules.AGGREGATE_PROJECT_STAR_TABLE, (Object)CoreRules.FILTER_SCAN, (Object)CoreRules.FILTER_PROJECT_TRANSPOSE, (Object)CoreRules.JOIN_PUSH_EXPRESSIONS, (Object)CoreRules.AGGREGATE_EXPAND_WITHIN_DISTINCT, (Object)CoreRules.AGGREGATE_CASE_TO_FILTER, (Object)CoreRules.FILTER_AGGREGATE_TRANSPOSE, (Object)CoreRules.PROJECT_WINDOW_TRANSPOSE, (Object)CoreRules.MATCH, (Object)CoreRules.SORT_PROJECT_TRANSPOSE, (Object)CoreRules.SORT_JOIN_TRANSPOSE, (Object[])new RelOptRule[]{CoreRules.SORT_REMOVE_CONSTANT_KEYS, CoreRules.SORT_UNION_TRANSPOSE, CoreRules.EXCHANGE_REMOVE_CONSTANT_KEYS, CoreRules.SORT_EXCHANGE_REMOVE_CONSTANT_KEYS});
    private static final List<RelOptRule> DEFAULT_BINDABLE_RULES = ImmutableList.of((Object)Bindables.BINDABLE_TABLE_SCAN_RULE, (Object)CoreRules.PROJECT_TABLE_SCAN, (Object)CoreRules.PROJECT_INTERPRETER_TABLE_SCAN);
    private static final List<RelOptRule> REDUCTION_RULES = ImmutableList.of((Object)CoreRules.PROJECT_REDUCE_EXPRESSIONS, (Object)CoreRules.FILTER_REDUCE_EXPRESSIONS, (Object)CoreRules.CALC_REDUCE_EXPRESSIONS, (Object)CoreRules.WINDOW_REDUCE_EXPRESSIONS, (Object)CoreRules.FILTER_VALUES_MERGE, (Object)CoreRules.PROJECT_FILTER_VALUES_MERGE, (Object)CoreRules.PROJECT_VALUES_MERGE, (Object)CoreRules.AGGREGATE_VALUES);
    private static final List<RelOptRule> ABSTRACT_RULES = ImmutableList.of((Object)CoreRules.AGGREGATE_ANY_PULL_UP_CONSTANTS, (Object)CoreRules.UNION_PULL_UP_CONSTANTS, (Object)PruneEmptyRules.UNION_INSTANCE, (Object)PruneEmptyRules.INTERSECT_INSTANCE, (Object)PruneEmptyRules.MINUS_INSTANCE, (Object)PruneEmptyRules.PROJECT_INSTANCE, (Object)PruneEmptyRules.FILTER_INSTANCE, (Object)PruneEmptyRules.SORT_INSTANCE, (Object)PruneEmptyRules.AGGREGATE_INSTANCE, (Object)PruneEmptyRules.JOIN_LEFT_INSTANCE, (Object)PruneEmptyRules.JOIN_RIGHT_INSTANCE, (Object)PruneEmptyRules.SORT_FETCH_ZERO_INSTANCE, (Object[])new RelOptRule[]{PruneEmptyRules.EMPTY_TABLE_INSTANCE, CoreRules.PROJECT_TO_LOGICAL_PROJECT_AND_WINDOW, CoreRules.FILTER_MERGE, CoreRules.INTERSECT_TO_DISTINCT});
    private static final List<RelOptRule> ABSTRACT_RELATIONAL_RULES = ImmutableList.of((Object)AbstractConverter.ExpandConversionRule.INSTANCE, (Object)CoreRules.AGGREGATE_REMOVE, (Object)CoreRules.UNION_TO_DISTINCT, (Object)CoreRules.PROJECT_REMOVE, (Object)CoreRules.AGGREGATE_JOIN_TRANSPOSE, (Object)CoreRules.AGGREGATE_PROJECT_MERGE, (Object)CoreRules.CALC_REMOVE, (Object)CoreRules.SORT_REMOVE);
    private static final List<RelOptRule> FANCY_JOIN_RULES = ImmutableList.of((Object)CoreRules.PROJECT_JOIN_TRANSPOSE, (Object)CoreRules.PROJECT_JOIN_REMOVE, (Object)CoreRules.FILTER_INTO_JOIN, (Object)CoreRules.JOIN_PUSH_EXPRESSIONS, (Object)CoreRules.SORT_JOIN_TRANSPOSE, (Object)JoinPushThroughJoinRule.LEFT, (Object)CoreRules.JOIN_COMMUTE);
    private final Set<ExtensionCalciteRuleProvider> extensionCalciteRuleProviderSet;

    @Inject
    public CalciteRulesManager(Set<ExtensionCalciteRuleProvider> extensionCalciteRuleProviderSet) {
        this.extensionCalciteRuleProviderSet = extensionCalciteRuleProviderSet;
    }

    public List<Program> programs(PlannerContext plannerContext) {
        boolean isDebug = plannerContext.queryContext().isDebug();
        Program druidPreProgram = this.buildPreProgram(plannerContext, true);
        Program bindablePreProgram = this.buildPreProgram(plannerContext, false);
        return ImmutableList.of((Object)Programs.sequence((Program[])new Program[]{druidPreProgram, SaveLogicalPlanProgram.INSTANCE, Programs.ofRules(this.druidConventionRuleSet(plannerContext)), new LoggingProgram("After Druid volcano planner program", isDebug)}), (Object)Programs.sequence((Program[])new Program[]{bindablePreProgram, SaveLogicalPlanProgram.INSTANCE, Programs.ofRules(this.bindableConventionRuleSet(plannerContext)), new LoggingProgram("After bindable volcano planner program", isDebug)}), (Object)Programs.sequence((Program[])new Program[]{druidPreProgram, this.buildDecoupledLogicalOptimizationProgram(plannerContext), SaveLogicalPlanProgram.INSTANCE, new LoggingProgram("After DecoupledLogicalOptimizationProgram program", isDebug), Programs.ofRules(this.logicalConventionRuleSet(plannerContext)), new LoggingProgram("After logical volcano planner program", isDebug)}));
    }

    private Program buildDecoupledLogicalOptimizationProgram(PlannerContext plannerContext) {
        HepProgramBuilder builder = HepProgram.builder();
        builder.addMatchLimit(HEP_DEFAULT_MATCH_LIMIT);
        builder.addGroupBegin();
        builder.addRuleCollection(this.baseRuleSet(plannerContext));
        builder.addRuleInstance((RelOptRule)CoreRules.UNION_MERGE);
        builder.addGroupEnd();
        return Programs.of((HepProgram)builder.build(), (boolean)true, (RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE);
    }

    private Program buildPreProgram(PlannerContext plannerContext, boolean isDruid) {
        boolean isDebug = plannerContext.queryContext().isDebug();
        ArrayList<Program> prePrograms = new ArrayList<Program>();
        prePrograms.add(new LoggingProgram("Start", isDebug));
        prePrograms.add(this.sqlToRelWorkaroundProgram());
        prePrograms.add(Programs.subQuery((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE));
        prePrograms.add(new LoggingProgram("Finished subquery program", isDebug));
        prePrograms.add(DecorrelateAndTrimFieldsProgram.INSTANCE);
        prePrograms.add(new LoggingProgram("Finished decorrelate and trim fields program", isDebug));
        prePrograms.add(this.buildReductionProgram(plannerContext, isDruid));
        prePrograms.add(new LoggingProgram("Finished expression reduction program", isDebug));
        if (isDruid) {
            prePrograms.add(this.buildPreVolcanoManipulationProgram(plannerContext));
            prePrograms.add(new LoggingProgram("Finished pre-Volcano manipulation program", isDebug));
        }
        return Programs.sequence((Program[])prePrograms.toArray(new Program[0]));
    }

    private Program sqlToRelWorkaroundProgram() {
        Set<FixIncorrectInExpansionTypes> rules = Collections.singleton(new FixIncorrectInExpansionTypes());
        return Programs.hep(rules, (boolean)true, (RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE);
    }

    private Program buildPreVolcanoManipulationProgram(PlannerContext plannerContext) {
        HepProgramBuilder builder = HepProgram.builder();
        builder.addMatchLimit(HEP_DEFAULT_MATCH_LIMIT);
        if (plannerContext.getJoinAlgorithm().requiresSubquery()) {
            builder.addRuleInstance((RelOptRule)CoreRules.FILTER_INTO_JOIN);
        }
        builder.addRuleInstance((RelOptRule)CoreRules.SORT_PROJECT_TRANSPOSE);
        return Programs.of((HepProgram)builder.build(), (boolean)true, (RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE);
    }

    private Program buildReductionProgram(PlannerContext plannerContext, boolean isDruid) {
        HepProgramBuilder builder = HepProgram.builder();
        builder.addMatchLimit(HEP_DEFAULT_MATCH_LIMIT);
        if (isDruid) {
            builder.addRuleInstance((RelOptRule)new CaseToCoalesceRule());
            builder.addRuleInstance((RelOptRule)new CoalesceLookupRule());
            builder.addRuleInstance((RelOptRule)new RewriteFirstValueLastValueRule());
        }
        builder.addGroupBegin();
        if (isDruid) {
            builder.addRuleInstance((RelOptRule)new FlattenConcatRule());
            builder.addRuleInstance((RelOptRule)new FilterDecomposeCoalesceRule());
            builder.addRuleInstance((RelOptRule)new FilterDecomposeConcatRule());
            if (plannerContext.isPullUpLookup()) {
                builder.addRuleInstance((RelOptRule)new AggregatePullUpLookupRule(plannerContext));
            }
            if (plannerContext.isReverseLookup()) {
                builder.addRuleInstance((RelOptRule)new ReverseLookupRule(plannerContext));
            }
        }
        for (RelOptRule rule : REDUCTION_RULES) {
            builder.addRuleInstance(rule);
        }
        builder.addGroupEnd();
        return Programs.of((HepProgram)builder.build(), (boolean)true, (RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE);
    }

    public List<RelOptRule> druidConventionRuleSet(PlannerContext plannerContext) {
        ImmutableList.Builder retVal = ImmutableList.builder().addAll(this.baseRuleSet(plannerContext)).add((Object)DruidRelToDruidRule.instance()).add((Object)new DruidTableScanRule(plannerContext)).add((Object)new DruidLogicalValuesRule(plannerContext)).add((Object)new ExternalTableScanRule(plannerContext)).addAll(DruidRules.rules(plannerContext));
        for (ExtensionCalciteRuleProvider extensionCalciteRuleProvider : this.extensionCalciteRuleProviderSet) {
            retVal.add((Object)extensionCalciteRuleProvider.getRule(plannerContext));
        }
        return retVal.build();
    }

    public List<RelOptRule> logicalConventionRuleSet(PlannerContext plannerContext) {
        ImmutableList.Builder retVal = ImmutableList.builder().add((Object)CoreRules.SORT_REMOVE).add((Object[])new DruidLogicalRules(plannerContext).rules().toArray(new RelOptRule[0]));
        return retVal.build();
    }

    public List<RelOptRule> bindableConventionRuleSet(PlannerContext plannerContext) {
        return ImmutableList.builder().addAll(this.baseRuleSet(plannerContext)).addAll((Iterable)Bindables.RULES).addAll(DEFAULT_BINDABLE_RULES).add((Object)CoreRules.AGGREGATE_REDUCE_FUNCTIONS).build();
    }

    public List<RelOptRule> configurableRuleSet(PlannerContext plannerContext) {
        return ImmutableList.of((Object)ProjectMergeRule.Config.DEFAULT.withBloat(this.getBloatProperty(plannerContext)).toRule());
    }

    private int getBloatProperty(PlannerContext plannerContext) {
        Integer bloat = plannerContext.queryContext().getInt(BLOAT_PROPERTY);
        return bloat != null ? bloat : 1000;
    }

    public List<RelOptRule> baseRuleSet(PlannerContext plannerContext) {
        PlannerConfig plannerConfig = plannerContext.getPlannerConfig();
        ImmutableList.Builder rules = ImmutableList.builder();
        rules.addAll(BASE_RULES);
        rules.addAll(ABSTRACT_RULES);
        rules.addAll(ABSTRACT_RELATIONAL_RULES);
        rules.addAll(this.configurableRuleSet(plannerContext));
        if (plannerContext.getJoinAlgorithm().requiresSubquery()) {
            rules.addAll(FANCY_JOIN_RULES);
        }
        if (!plannerConfig.isUseApproximateCountDistinct()) {
            if (plannerConfig.isUseGroupingSetForExactDistinct() && plannerContext.featureAvailable(EngineFeature.GROUPING_SETS)) {
                rules.add((Object)CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES);
            } else {
                rules.add((Object)CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES_TO_JOIN);
            }
        }
        rules.add(FilterJoinExcludePushToChildRule.FILTER_ON_JOIN_EXCLUDE_PUSH_TO_CHILD);
        rules.add((Object)SortCollapseRule.instance());
        rules.add((Object)ProjectAggregatePruneUnusedCallRule.instance());
        rules.add((Object)DruidAggregateRemoveRedundancyRule.instance());
        return rules.build();
    }

    private static class DecorrelateAndTrimFieldsProgram
    implements Program {
        private static final DecorrelateAndTrimFieldsProgram INSTANCE = new DecorrelateAndTrimFieldsProgram();

        private DecorrelateAndTrimFieldsProgram() {
        }

        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
            RelNode decorrelatedRel = RelDecorrelator.decorrelateQuery((RelNode)rel, (RelBuilder)relBuilder);
            return new RelFieldTrimmer(null, relBuilder).trim(decorrelatedRel);
        }
    }

    private static class LoggingProgram
    implements Program {
        private final String stage;
        private final boolean isDebug;

        public LoggingProgram(String stage, boolean isDebug) {
            this.stage = stage;
            this.isDebug = isDebug;
        }

        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            if (this.isDebug) {
                log.info("%s%n%s", new Object[]{this.stage, RelOptUtil.dumpPlan((String)"", (RelNode)rel, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES)});
            }
            return rel;
        }
    }

    private static class SaveLogicalPlanProgram
    implements Program {
        public static SaveLogicalPlanProgram INSTANCE = new SaveLogicalPlanProgram();

        private SaveLogicalPlanProgram() {
        }

        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            PlannerContext pctx = (PlannerContext)planner.getContext().unwrapOrThrow(PlannerContext.class);
            pctx.dispatchHook(DruidHook.LOGICAL_PLAN, rel);
            return rel;
        }
    }
}

