/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.QueryContexts;
import org.joda.time.DateTimeZone;

public class PlannerConfig {
    public static final String CTX_KEY_USE_APPROXIMATE_COUNT_DISTINCT = "useApproximateCountDistinct";
    public static final String CTX_KEY_USE_GROUPING_SET_FOR_EXACT_DISTINCT = "useGroupingSetForExactDistinct";
    public static final String CTX_KEY_USE_APPROXIMATE_TOPN = "useApproximateTopN";
    public static final String CTX_COMPUTE_INNER_JOIN_COST_AS_FILTER = "computeInnerJoinCostAsFilter";
    public static final String CTX_KEY_USE_NATIVE_QUERY_EXPLAIN = "useNativeQueryExplain";
    public static final String CTX_KEY_FORCE_EXPRESSION_VIRTUAL_COLUMNS = "forceExpressionVirtualColumns";
    public static final String CTX_MAX_NUMERIC_IN_FILTERS = "maxNumericInFilters";
    public static final String CTX_NATIVE_QUERY_SQL_PLANNING_MODE = "plannerStrategy";
    public static final int NUM_FILTER_NOT_USED = -1;
    @JsonProperty
    private int maxTopNLimit = 100000;
    @JsonProperty
    private boolean useApproximateCountDistinct = true;
    @JsonProperty
    private boolean useApproximateTopN = true;
    @JsonProperty
    private boolean requireTimeCondition = false;
    @JsonProperty
    private DateTimeZone sqlTimeZone = DateTimeZone.UTC;
    @JsonProperty
    private boolean useGroupingSetForExactDistinct = false;
    @JsonProperty
    private boolean computeInnerJoinCostAsFilter = true;
    @JsonProperty
    private boolean authorizeSystemTablesDirectly = false;
    @JsonProperty
    private boolean useNativeQueryExplain = true;
    @JsonProperty
    private boolean forceExpressionVirtualColumns = false;
    @JsonProperty
    private int maxNumericInFilters = -1;
    @JsonProperty
    private String nativeQuerySqlPlanningMode = "COUPLED";
    public static final String NATIVE_QUERY_SQL_PLANNING_MODE_COUPLED = "COUPLED";
    public static final String NATIVE_QUERY_SQL_PLANNING_MODE_DECOUPLED = "DECOUPLED";
    private boolean serializeComplexValues = true;

    public int getMaxNumericInFilters() {
        return this.maxNumericInFilters;
    }

    public int getMaxTopNLimit() {
        return this.maxTopNLimit;
    }

    public boolean isUseApproximateCountDistinct() {
        return this.useApproximateCountDistinct;
    }

    public boolean isUseGroupingSetForExactDistinct() {
        return this.useGroupingSetForExactDistinct;
    }

    public boolean isUseApproximateTopN() {
        return this.useApproximateTopN;
    }

    public boolean isRequireTimeCondition() {
        return this.requireTimeCondition;
    }

    public DateTimeZone getSqlTimeZone() {
        return this.sqlTimeZone;
    }

    public boolean shouldSerializeComplexValues() {
        return this.serializeComplexValues;
    }

    public boolean isComputeInnerJoinCostAsFilter() {
        return this.computeInnerJoinCostAsFilter;
    }

    public boolean isAuthorizeSystemTablesDirectly() {
        return this.authorizeSystemTablesDirectly;
    }

    public boolean isUseNativeQueryExplain() {
        return this.useNativeQueryExplain;
    }

    public boolean isForceExpressionVirtualColumns() {
        return this.forceExpressionVirtualColumns;
    }

    public String getNativeQuerySqlPlanningMode() {
        return this.nativeQuerySqlPlanningMode;
    }

    public PlannerConfig withOverrides(Map<String, Object> queryContext) {
        if (queryContext.isEmpty()) {
            return this;
        }
        return this.toBuilder().withOverrides(queryContext).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlannerConfig that = (PlannerConfig)o;
        return this.maxTopNLimit == that.maxTopNLimit && this.useApproximateCountDistinct == that.useApproximateCountDistinct && this.useApproximateTopN == that.useApproximateTopN && this.requireTimeCondition == that.requireTimeCondition && this.serializeComplexValues == that.serializeComplexValues && Objects.equals(this.sqlTimeZone, that.sqlTimeZone) && this.useNativeQueryExplain == that.useNativeQueryExplain && this.forceExpressionVirtualColumns == that.forceExpressionVirtualColumns && this.useGroupingSetForExactDistinct == that.useGroupingSetForExactDistinct && this.computeInnerJoinCostAsFilter == that.computeInnerJoinCostAsFilter && this.authorizeSystemTablesDirectly == that.authorizeSystemTablesDirectly && this.maxNumericInFilters == that.maxNumericInFilters && this.nativeQuerySqlPlanningMode.equals(that.nativeQuerySqlPlanningMode);
    }

    public int hashCode() {
        return Objects.hash(this.maxTopNLimit, this.useApproximateCountDistinct, this.useApproximateTopN, this.requireTimeCondition, this.sqlTimeZone, this.serializeComplexValues, this.useNativeQueryExplain, this.forceExpressionVirtualColumns, this.nativeQuerySqlPlanningMode);
    }

    public String toString() {
        return "PlannerConfig{maxTopNLimit=" + this.maxTopNLimit + ", useApproximateCountDistinct=" + this.useApproximateCountDistinct + ", useApproximateTopN=" + this.useApproximateTopN + ", requireTimeCondition=" + this.requireTimeCondition + ", sqlTimeZone=" + this.sqlTimeZone + ", serializeComplexValues=" + this.serializeComplexValues + ", useNativeQueryExplain=" + this.useNativeQueryExplain + ", nativeQuerySqlPlanningMode=" + this.nativeQuerySqlPlanningMode + '}';
    }

    public static Builder builder() {
        return new PlannerConfig().toBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Map<String, Object> getNonDefaultAsQueryContext() {
        PlannerConfig newConfig;
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        PlannerConfig def = new PlannerConfig();
        if (def.useApproximateCountDistinct != this.useApproximateCountDistinct) {
            overrides.put(CTX_KEY_USE_APPROXIMATE_COUNT_DISTINCT, String.valueOf(this.useApproximateCountDistinct));
        }
        if (def.useGroupingSetForExactDistinct != this.useGroupingSetForExactDistinct) {
            overrides.put(CTX_KEY_USE_GROUPING_SET_FOR_EXACT_DISTINCT, String.valueOf(this.useGroupingSetForExactDistinct));
        }
        if (!this.equals(newConfig = PlannerConfig.builder().withOverrides(overrides).build())) {
            throw DruidException.defensive((String)"Not all PlannerConfig options are not persistable as QueryContext keys!\nold: %s\nnew: %s", (Object[])new Object[]{this, newConfig});
        }
        return overrides;
    }

    public static class Builder {
        private int maxTopNLimit;
        private boolean useApproximateCountDistinct;
        private boolean useApproximateTopN;
        private boolean requireTimeCondition;
        private DateTimeZone sqlTimeZone;
        private boolean useGroupingSetForExactDistinct;
        private boolean computeInnerJoinCostAsFilter;
        private boolean authorizeSystemTablesDirectly;
        private boolean useNativeQueryExplain;
        private boolean forceExpressionVirtualColumns;
        private int maxNumericInFilters;
        private boolean serializeComplexValues;
        private String nativeQuerySqlPlanningMode;

        public Builder(PlannerConfig base) {
            this.maxTopNLimit = base.getMaxTopNLimit();
            this.useApproximateCountDistinct = base.isUseApproximateCountDistinct();
            this.useApproximateTopN = base.isUseApproximateTopN();
            this.requireTimeCondition = base.isRequireTimeCondition();
            this.sqlTimeZone = base.getSqlTimeZone();
            this.useGroupingSetForExactDistinct = base.isUseGroupingSetForExactDistinct();
            this.computeInnerJoinCostAsFilter = base.computeInnerJoinCostAsFilter;
            this.authorizeSystemTablesDirectly = base.isAuthorizeSystemTablesDirectly();
            this.useNativeQueryExplain = base.isUseNativeQueryExplain();
            this.forceExpressionVirtualColumns = base.isForceExpressionVirtualColumns();
            this.maxNumericInFilters = base.getMaxNumericInFilters();
            this.serializeComplexValues = base.shouldSerializeComplexValues();
            this.nativeQuerySqlPlanningMode = base.getNativeQuerySqlPlanningMode();
        }

        public Builder requireTimeCondition(boolean option) {
            this.requireTimeCondition = option;
            return this;
        }

        public Builder maxTopNLimit(int value) {
            this.maxTopNLimit = value;
            return this;
        }

        public Builder maxNumericInFilters(int value) {
            this.maxNumericInFilters = value;
            return this;
        }

        public Builder useApproximateCountDistinct(boolean option) {
            this.useApproximateCountDistinct = option;
            return this;
        }

        public Builder useApproximateTopN(boolean option) {
            this.useApproximateTopN = option;
            return this;
        }

        public Builder useGroupingSetForExactDistinct(boolean option) {
            this.useGroupingSetForExactDistinct = option;
            return this;
        }

        public Builder computeInnerJoinCostAsFilter(boolean option) {
            this.computeInnerJoinCostAsFilter = option;
            return this;
        }

        public Builder sqlTimeZone(DateTimeZone value) {
            this.sqlTimeZone = value;
            return this;
        }

        public Builder authorizeSystemTablesDirectly(boolean option) {
            this.authorizeSystemTablesDirectly = option;
            return this;
        }

        public Builder serializeComplexValues(boolean option) {
            this.serializeComplexValues = option;
            return this;
        }

        public Builder useNativeQueryExplain(boolean option) {
            this.useNativeQueryExplain = option;
            return this;
        }

        public Builder nativeQuerySqlPlanningMode(String mode) {
            this.nativeQuerySqlPlanningMode = mode;
            return this;
        }

        public Builder withOverrides(Map<String, Object> queryContext) {
            this.useApproximateCountDistinct = QueryContexts.parseBoolean(queryContext, (String)PlannerConfig.CTX_KEY_USE_APPROXIMATE_COUNT_DISTINCT, (boolean)this.useApproximateCountDistinct);
            this.useGroupingSetForExactDistinct = QueryContexts.parseBoolean(queryContext, (String)PlannerConfig.CTX_KEY_USE_GROUPING_SET_FOR_EXACT_DISTINCT, (boolean)this.useGroupingSetForExactDistinct);
            this.useApproximateTopN = QueryContexts.parseBoolean(queryContext, (String)PlannerConfig.CTX_KEY_USE_APPROXIMATE_TOPN, (boolean)this.useApproximateTopN);
            this.computeInnerJoinCostAsFilter = QueryContexts.parseBoolean(queryContext, (String)PlannerConfig.CTX_COMPUTE_INNER_JOIN_COST_AS_FILTER, (boolean)this.computeInnerJoinCostAsFilter);
            this.useNativeQueryExplain = QueryContexts.parseBoolean(queryContext, (String)PlannerConfig.CTX_KEY_USE_NATIVE_QUERY_EXPLAIN, (boolean)this.useNativeQueryExplain);
            this.forceExpressionVirtualColumns = QueryContexts.parseBoolean(queryContext, (String)PlannerConfig.CTX_KEY_FORCE_EXPRESSION_VIRTUAL_COLUMNS, (boolean)this.forceExpressionVirtualColumns);
            int queryContextMaxNumericInFilters = QueryContexts.parseInt(queryContext, (String)PlannerConfig.CTX_MAX_NUMERIC_IN_FILTERS, (int)this.maxNumericInFilters);
            this.maxNumericInFilters = Builder.validateMaxNumericInFilters(queryContextMaxNumericInFilters, this.maxNumericInFilters);
            this.nativeQuerySqlPlanningMode = QueryContexts.parseString(queryContext, (String)PlannerConfig.CTX_NATIVE_QUERY_SQL_PLANNING_MODE, (String)this.nativeQuerySqlPlanningMode);
            return this;
        }

        private static int validateMaxNumericInFilters(int queryContextMaxNumericInFilters, int systemConfigMaxNumericInFilters) {
            if (queryContextMaxNumericInFilters == 0) {
                throw new UOE("[%s] must be greater than 0", new Object[]{PlannerConfig.CTX_MAX_NUMERIC_IN_FILTERS});
            }
            if (queryContextMaxNumericInFilters > systemConfigMaxNumericInFilters && systemConfigMaxNumericInFilters != -1) {
                throw new UOE("Expected parameter[%s] cannot exceed system set value of [%d]", new Object[]{PlannerConfig.CTX_MAX_NUMERIC_IN_FILTERS, systemConfigMaxNumericInFilters});
            }
            if (systemConfigMaxNumericInFilters == -1) {
                return systemConfigMaxNumericInFilters;
            }
            return queryContextMaxNumericInFilters;
        }

        public PlannerConfig build() {
            PlannerConfig config = new PlannerConfig();
            config.maxTopNLimit = this.maxTopNLimit;
            config.useApproximateCountDistinct = this.useApproximateCountDistinct;
            config.useApproximateTopN = this.useApproximateTopN;
            config.requireTimeCondition = this.requireTimeCondition;
            config.sqlTimeZone = this.sqlTimeZone;
            config.useGroupingSetForExactDistinct = this.useGroupingSetForExactDistinct;
            config.computeInnerJoinCostAsFilter = this.computeInnerJoinCostAsFilter;
            config.authorizeSystemTablesDirectly = this.authorizeSystemTablesDirectly;
            config.useNativeQueryExplain = this.useNativeQueryExplain;
            config.maxNumericInFilters = this.maxNumericInFilters;
            config.forceExpressionVirtualColumns = this.forceExpressionVirtualColumns;
            config.serializeComplexValues = this.serializeComplexValues;
            config.nativeQuerySqlPlanningMode = this.nativeQuerySqlPlanningMode;
            return config;
        }
    }
}

