/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.planner.JoinAlgorithm;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.EngineFeature;

public class QueryValidations {
    public static void validateLogicalQueryForDruid(PlannerContext plannerContext, RelNode relNode) throws ValidationException {
        QueryValidations.validateNoIllegalRightyJoins(plannerContext, relNode);
    }

    private static void validateNoIllegalRightyJoins(PlannerContext plannerContext, RelNode relNode) throws ValidationException {
        if (plannerContext.getJoinAlgorithm() == JoinAlgorithm.BROADCAST && !plannerContext.featureAvailable(EngineFeature.ALLOW_BROADCAST_RIGHTY_JOIN)) {
            class FindRightyJoin
            extends RelShuttleImpl {
                private Join found = null;

                FindRightyJoin() {
                }

                public RelNode visit(LogicalJoin join) {
                    if (join.getJoinType().generatesNullsOnLeft()) {
                        this.found = join;
                    }
                    return this.visitChildren((RelNode)join);
                }
            }
            FindRightyJoin shuttle = new FindRightyJoin();
            relNode.accept((RelShuttle)shuttle);
            if (shuttle.found != null) {
                throw new ValidationException(StringUtils.format((String)"%s join is not supported by engine [%s] with %s: [%s]. Try %s: %s.", (Object[])new Object[]{shuttle.found.getJoinType(), plannerContext.getEngine().name(), "sqlJoinAlgorithm", plannerContext.getJoinAlgorithm(), "sqlJoinAlgorithm", JoinAlgorithm.SORT_MERGE.toString()}));
            }
        }
    }
}

